package pum.simuref.modeltocode.participant.participants;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.IParticipantDescriptorFilter;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.ParticipantDescriptor;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;

/**
 * TODO: Copy&Paste Class, genauer verstehen.
 * @author alex
 *
 */
@SuppressWarnings("restriction")
public class EmfParticipantExtensionPoint {

	private String fParticipantID;
	private List fParticipants;
	private Class fParticipantClass;
	private String fPluginId;

	public EmfParticipantExtensionPoint(String pluginId, String participantId,
			Class clazz) {
		Assert.isNotNull(participantId);
		fParticipantID = participantId;
		fParticipantClass = clazz;
		fPluginId = pluginId;
	}

	public RefactoringParticipant[] getParticipants(RefactoringStatus status, RefactoringProcessor processor, 
			Object element, RefactoringArguments arguments, IParticipantDescriptorFilter filter, 
			String[] affectedNatures, SharableParticipants shared, String emfRefactoringId) {

		init(emfRefactoringId);
		List result = new ArrayList();
		for (Iterator iter = fParticipants.iterator(); iter.hasNext();) {
			ParticipantDescriptor descriptor = (ParticipantDescriptor) iter
					.next();
			if (!descriptor.isEnabled()) {
				iter.remove();
			} else {
				try {
					RefactoringStatus filterStatus = new RefactoringStatus();
					RefactoringParticipant participant = descriptor
							.createParticipant();
					if (fParticipantClass.isInstance(participant)) {
						if (participant.initialize(processor, element,
								arguments)) {
							// participant.setDescriptor(descriptor);
							result.add(participant);
						}
					} else {
						status.addError(Messages
								.format(RefactoringCoreMessages.ParticipantExtensionPoint_participant_removed,
										descriptor.getName()));
						RefactoringCorePlugin
								.logErrorMessage(Messages
										.format(RefactoringCoreMessages.ParticipantExtensionPoint_wrong_type,
												new String[] {
														descriptor.getName(),
														fParticipantClass
																.getName() }));
						iter.remove();
					}
				} catch (CoreException e) {
					logMalfunctioningParticipant(status, descriptor, e);
					iter.remove();
				} catch (RuntimeException e) {
					logMalfunctioningParticipant(status, descriptor, e);
					iter.remove();
				}
			}
		}

		return (RefactoringParticipant[]) result
				.toArray(new RefactoringParticipant[result.size()]);
	}

	private void logMalfunctioningParticipant(RefactoringStatus status,
			ParticipantDescriptor descriptor, Throwable e) {
		status.addError(Messages
				.format(RefactoringCoreMessages.ParticipantExtensionPoint_participant_removed,
						descriptor.getName()));
		RefactoringCorePlugin.logRemovedParticipant(descriptor, e);
	}

	private void init(String emfRefactoringId) {
		IExtensionRegistry registry = Platform.getExtensionRegistry();
		IConfigurationElement[] ces = registry.getConfigurationElementsFor(
				fPluginId, fParticipantID);
		fParticipants = new ArrayList(ces.length);
		for (int i = 0; i < ces.length; i++) {
			System.out.println("emfRefactoringId" + ces[i].getAttribute("emfRefactoringId"));
			// Anpassung AW - mit Vorsicht zu genieen.
			if ((ces[i].getAttribute("emfRefactoringId") != null && (!ces[i].getAttribute("emfRefactoringId").equals(emfRefactoringId))))
				continue;
			ParticipantDescriptor descriptor = new ParticipantDescriptor(ces[i]);
			IStatus status = descriptor.checkSyntax();
			switch (status.getSeverity()) {
			case IStatus.ERROR:
				RefactoringCorePlugin.log(status);
				break;
			case IStatus.WARNING:
			case IStatus.INFO:
				RefactoringCorePlugin.log(status);
				fParticipants.add(descriptor);
				break;
			default:
				fParticipants.add(descriptor);
			}
		}
	}
}
