/**
 * <copyright>
 * </copyright>
 *
 * $Id: RefactoringController.javajet,v 1.2 2012/10/16 21:03:02 tarendt Exp $
 */
package simplewebmodel.refactorings.createindexpageanddatapage;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.refactor.refactoring.core.Refactoring;
import org.eclipse.emf.refactor.refactoring.interfaces.IController;
import org.eclipse.emf.refactor.refactoring.interfaces.IDataManagement;
import org.eclipse.emf.refactor.refactoring.runtime.ltk.LtkEmfRefactoringProcessorAdapter;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;

import simplewebmodel.DataPage;
import simplewebmodel.Entity;
import simplewebmodel.IndexPage;
import simplewebmodel.Link;
import simplewebmodel.SimplewebmodelFactory;
import simplewebmodel.WebModel;

public final class RefactoringController implements IController{

	/**
	 * Refactoring supported by the controller.
	 * @generated
	 */
	private Refactoring parent;
	
	/**
	 * DataManagement object of the model refactoring.
	 * @generated
	 */
	private RefactoringDataManagement dataManagement = 
									new RefactoringDataManagement();
	
	/**
	 * Invocation context of the model refactoring.
	 * @generated
	 */	
	private List<EObject> selection = new ArrayList<EObject>();
	
	/**
	 * Ltk RefactoringProcessor of the model refactoring.
	 * @generated
	 */
	private InternalRefactoringProcessor refactoringProcessor = null;
	
	/**
	 * Gets the Refactoring supported by the controller.
	 * @return Refactoring supported by the controller.
	 * @see org.eclipse.emf.refactor.refactoring.interfaces.IController#getParent()
	 * @generated
	 */
	@Override
	public Refactoring getParent() {
		return this.parent;
	}
	
	/**
	 * Sets the Refactoring supported by the controller.
	 * @param emfRefactoring Refactoring supported by the controller.
	 * @see org.eclipse.emf.refactor.refactoring.interfaces.IController#
	 * setParent(org.eclipse.emf.refactor.refactoring.core.Refactoring)
	 * @generated
	 */
	@Override
	public void setParent(Refactoring emfRefactoring) {
		this.parent = emfRefactoring;
	}
	
	/**
	 * Returns the DataManagement object of the model refactoring.
	 * @return DataManagement object of the model refactoring.
	 * @see org.eclipse.emf.refactor.refactoring.interfaces.IController#
	 * getDataManagementObject()
	 * @generated
	 */
	@Override
	public IDataManagement getDataManagementObject() {
		return this.dataManagement;
	}

	/**
	 * Returns the ltk RefactoringProcessor of the model refactoring.
	 * @return Ltk RefactoringProcessor of the model refactoring.
	 * @see org.eclipse.emf.refactor.refactoring.interfaces.IController#
	 * getLtkRefactoringProcessor()
	 * @generated
	 */
	@Override
	public RefactoringProcessor getLtkRefactoringProcessor() {
		return this.refactoringProcessor;
	}
	
	/**
	 * Sets the selected EObject (invocation context of the model refactoring).
	 * @param selection Invocation context of the model refactoring.
	 * @see org.eclipse.emf.refactor.refactoring.interfaces.IController#
	 * setSelection(java.util.List)
	 * @generated
	 */
	@Override
	public void setSelection(List<EObject> selection) {
		this.selection = selection;
		this.refactoringProcessor = 
				new InternalRefactoringProcessor(this.selection);
	}	
	
	/**
	 * Returns a Runnable object that executes the model refactoring.
	 * @return Runnable object that executes the model refactoring.
	 * @generated
	 */
	private Runnable applyRefactoring() {
		return new Runnable() {				
			/**
			 * @see java.lang.Runnable#run()
			 * @generated
			 */
			@Override
			public void run() {
				Entity entity = 
					(Entity) dataManagement.
							getInPortByName(dataManagement.SELECTEDEOBJECT).getValue();
				WebModel webModel = (WebModel) EcoreUtil.getRootContainer(entity);
				SimplewebmodelFactory factory = SimplewebmodelFactory.eINSTANCE;
				// create data page
				DataPage dataPage = factory.createDataPage();
				dataPage.setName(entity.getName().toLowerCase() + "data");
				dataPage.setEntity(entity);
				webModel.getHypertextLayer().getPages().add(dataPage);
				// create index page
				IndexPage indexPage = factory.createIndexPage();
				indexPage.setName(entity.getName().toLowerCase() + "index");
				indexPage.setEntity(entity);
				Link link = factory.createLink();
				link.setTarget(dataPage);
				indexPage.getLinks().add(link);
				webModel.getHypertextLayer().getPages().add(indexPage);
				// add link to start page
				Link indexLink = factory.createLink();
				indexLink.setTarget(indexPage);
				webModel.getHypertextLayer().getStartPage().getLinks().add(indexLink);				
			}
		};
	}

	/**
	 * Internal class for providing an instance of a LTK RefactoringProcessor 
	 * used for EMF model refactorings.	 
	 * @generated
	 */
	public final class InternalRefactoringProcessor extends 
									LtkEmfRefactoringProcessorAdapter {

		/**
		 * Constructor using the invocation context of the model refactoring.
		 * @param selection Invocation context of the model refactoring.
		 * @generated
		 */
		private InternalRefactoringProcessor(List<EObject> selection){
				super(getParent(), selection, applyRefactoring());				
		}
			
		/**
		 * @see org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor#
	 	 * checkInitialConditions(org.eclipse.core.runtime.IProgressMonitor)
		 * @generated
		 */	
		@Override
		public RefactoringStatus checkInitialConditions(){
			RefactoringStatus result = new RefactoringStatus();
			Entity entity = 
				(Entity) dataManagement.
						getInPortByName(dataManagement.SELECTEDEOBJECT).getValue();
			// check: entity must not be referenced by a data page
			List<DataPage> dataPages = getAllDataPages(root);
			for (DataPage dataPage : dataPages) {
				if (dataPage.getEntity() == entity) {
					result.addFatalError("There is already a data page referencing this entity!");
				}
			}
			// check: entity must not be referenced by an index page
			List<IndexPage> indexPages = getAllIndexPages(root);
			for (IndexPage indexPage : indexPages) {
				if (indexPage.getEntity() == entity) {
					result.addFatalError("There is already an index page referencing this entity!");
				}
			}
			return result;
		}
	
		private List<DataPage> getAllDataPages(EObject root) {
			List<DataPage> dataPages = new ArrayList<DataPage>();
			TreeIterator<EObject> iter = root.eAllContents();
			while (iter.hasNext()) {
				EObject eObject = iter.next();
				if (eObject instanceof DataPage) {
					dataPages.add((DataPage) eObject);
				}
			}
			return dataPages;
		}
		
		private List<IndexPage> getAllIndexPages(EObject root) {
			List<IndexPage> indexPages = new ArrayList<IndexPage>();
			TreeIterator<EObject> iter = root.eAllContents();
			while (iter.hasNext()) {
				EObject eObject = iter.next();
				if (eObject instanceof IndexPage) {
					indexPages.add((IndexPage) eObject);
				}
			}
			return indexPages;
		}
		
		/**
		 * @see org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor#
	     * checkFinalConditions(org.eclipse.core.runtime.IProgressMonitor, 
	     * org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext)
		 * @generated
		 */	
		@Override
		public RefactoringStatus checkFinalConditions(){
			RefactoringStatus result = new RefactoringStatus();
			// No additional parameters -> no final checks!
			return result;
		}
		
	}

}