package pam.refactorings;

import PAM.Cooling;

public class CoolingPair {
	
	private Cooling cooling1, cooling2;

	public CoolingPair(Cooling cooling1, Cooling cooling2) {
		super();
		this.cooling1 = cooling1;
		this.cooling2 = cooling2;
	}

	public Cooling getCooling1() {
		return cooling1;
	}

	public Cooling getCooling2() {
		return cooling2;
	}

	@Override
	public String toString() {
		return "<" + cooling1.getName() + ", " + cooling2.getName() + ">";
	}

	@Override
	public boolean equals(Object obj) {
		if (! (obj instanceof CoolingPair)) return false;
		CoolingPair pair = (CoolingPair) obj;
		return ((this.cooling1.equals(pair.cooling1) && this.cooling2.equals(pair.cooling2)) 
				|| (this.cooling1.equals(pair.cooling2) && this.cooling2.equals(pair.cooling1)));
	}
}
