package pam.refactorings;

import java.util.Date;
import java.util.Set;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.refactor.refactoring.core.Port;
import org.eclipse.emf.refactor.refactoring.core.Refactoring;

public abstract class Logger {
	
	@SuppressWarnings("rawtypes")
	public static void logRefactoring(Refactoring parent, EObject context) {
		EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
		annotation.setSource(Long.toString(new Date().getTime()));
		EStringToStringMapEntryImpl entry = (EStringToStringMapEntryImpl) 
				EcoreFactory.eINSTANCE.create(EcorePackage.eINSTANCE.getEStringToStringMapEntry());
		entry.setKey("Refactoring");
		entry.setValue(parent.getName());
		annotation.getDetails().add(entry);
		Set<Port> ports = parent.getController().getDataManagementObject().getInPorts();
		for (Port port : ports) {
			EStringToStringMapEntryImpl entryTmp = (EStringToStringMapEntryImpl) 
					EcoreFactory.eINSTANCE.create(EcorePackage.eINSTANCE.getEStringToStringMapEntry());
			entryTmp.setKey(port.getName());
			entryTmp.setValue(port.getValue().toString());
			annotation.getDetails().add(entryTmp);
		}
		context.eResource().getContents().add(annotation);
	}

}
