package pam.refactorings;

import PAM.NetworkNode;

public class NetworkNodePair {
	
	public NetworkNode getNode1() {
		return node1;
	}

	public NetworkNode getNode2() {
		return node2;
	}

	private NetworkNode node1, node2;
	
	public NetworkNodePair(NetworkNode node1, NetworkNode node2) {
		this.node1 = node1;
		this.node2 = node2;
	}

	@Override
	public String toString() {
		return "<" + node1.getName() + ", " + node2.getName() + ">";
	}
	
	@Override
	public boolean equals(Object obj) {
		if (! (obj instanceof NetworkNodePair)) return false;
		NetworkNodePair pair = (NetworkNodePair) obj;
		return ((this.node1.equals(pair.node1) && this.node2.equals(pair.node2)) 
				|| (this.node1.equals(pair.node2) && this.node2.equals(pair.node1)));
	}
}
