/**
 * <copyright>
 * </copyright>
 *
 * $Id: RefactoringWizardPageHenshin.javajet,v 1.2 2012/11/26 15:39:38 tarendt Exp $
 */
 package pam.refactorings.pam.coolingmerge;

import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

import PAM.Cooling;

import pam.refactorings.CoolingPair;

/**
 * Class for setting model refactoring specific parameters
 * by the user.
 * @generated
 */
public class RefactoringWizardPage extends 
				UserInputWizardPage implements Listener {
				
	/**
	 * Controller of the EMF model refactoring.
	 * @generated
	 */			
	private final RefactoringController controller;
	
	/**
	 * Label for each parameter.
	 * @generated
	 */
	private Label coolingPairLabel;
	
	private Combo coolingPairWidget;
	
	private Label coolingLabel;
	
	private Combo coolingWidget;

	/**
	 * Default constructor using a name and the controller of the 
	 * EMF model refactoring.
	 * @param name Name of the WizardPage.
	 * @param controller Controller of the EMF model refactoring.
	 * @generated
	 */
	public RefactoringWizardPage
		(String name, RefactoringController controller) {
		super(name);
		this.controller = controller;
	}

	/**
	 * @see org.eclipse.swt.widgets.Listener#
	 * handleEvent(org.eclipse.swt.widgets.Event)
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void handleEvent(Event event) {		
		getWizard().getContainer().updateButtons();
				
		if (event.widget == coolingPairWidget) {
			int index = coolingPairWidget.getSelectionIndex();
			CoolingPair coolingPair = controller.getCoolingPairs().get(index);
			((RefactoringDataManagement) this.controller.getDataManagementObject()).
						getInPortByName("selectedEObject").setValue(coolingPair.getCooling1());
			((RefactoringDataManagement) this.controller.getDataManagementObject()).
						getInPortByName("cooling2").setValue(coolingPair.getCooling2());
			coolingPairWidget.setEnabled(false);
			controller.setCoolings(coolingPair);
			coolingWidget.clearSelection();
			for (int i = 0; i < controller.getCoolings().size(); i++) {
				coolingWidget.add(controller.getCoolings().get(i).getName());
		    }
			coolingWidget.setEnabled(true);
		}
		
		if (event.widget == coolingWidget) {
			int index = coolingWidget.getSelectionIndex();
			Cooling cooling = controller.getCoolings().get(index);
			((RefactoringDataManagement) this.controller.getDataManagementObject()).
						getInPortByName("cooling").setValue(cooling);
		}
	}
	
	/**
	 * @see org.eclipse.jface.dialogs.IDialogPage#
	 * createControl(org.eclipse.swt.widgets.Composite)
	 * @generated
	 */
	@Override
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout gl = new GridLayout();
		gl.numColumns = 2;
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		composite.setLayout(gl);			
		
		coolingPairLabel = new Label(composite, SWT.NONE);
		coolingPairLabel.setText("Coolings to be merged: ");
		coolingPairLabel.setEnabled(true);
		
		coolingPairWidget = new Combo(composite, SWT.DROP_DOWN | SWT.BORDER);	
		coolingPairWidget.setToolTipText("Coolings to be merged");
		coolingPairWidget.setEnabled(true);
		coolingPairWidget.setLayoutData(gd);
		coolingPairWidget.addListener(SWT.Modify, this);
		
		for (int i = 0; i < controller.getCoolingPairs().size(); i++) {
			coolingPairWidget.add(controller.getCoolingPairs().get(i).toString());
	    }	
		
		coolingLabel = new Label(composite, SWT.NONE);
		coolingLabel.setText("Cooling to be used instead: ");
		coolingLabel.setEnabled(true);
		
		coolingWidget = new Combo(composite, SWT.DROP_DOWN | SWT.BORDER);	
		coolingWidget.setToolTipText("Cooling to be used instead");
		coolingWidget.setEnabled(false);
		coolingWidget.setLayoutData(gd);
		coolingWidget.addListener(SWT.Modify, this);
		
		setControl(composite);
	}
	
}
	