/**
 * <copyright>
 * </copyright>
 *
 * $Id: RefactoringWizardPageHenshin.javajet,v 1.2 2012/11/26 15:39:38 tarendt Exp $
 */
 package pam.refactorings.pam.networkmerge.opt;

import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

import pam.refactorings.NetworkNodePair;
import PAM.NetworkNode;

/**
 * Class for setting model refactoring specific parameters
 * by the user.
 * @generated
 */
public class RefactoringWizardPage extends 
				UserInputWizardPage implements Listener {
				
	/**
	 * Controller of the EMF model refactoring.
	 * @generated
	 */			
	private final RefactoringController controller;
	
	/**
	 * Label for each parameter.
	 * @generated
	 */
	private Label nwnPairLabel;
	
	private Combo nwnPairWidget;
	
	private Label nwnLabel;
	
	private Combo nwnWidget;

	/**
	 * Default constructor using a name and the controller of the 
	 * EMF model refactoring.
	 * @param name Name of the WizardPage.
	 * @param controller Controller of the EMF model refactoring.
	 * @generated
	 */
	public RefactoringWizardPage
		(String name, RefactoringController controller) {
		super(name);
		this.controller = controller;
	}

	/**
	 * @see org.eclipse.swt.widgets.Listener#
	 * handleEvent(org.eclipse.swt.widgets.Event)
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void handleEvent(Event event) {		
		getWizard().getContainer().updateButtons();
				
		if (event.widget == nwnPairWidget) {
			int index = nwnPairWidget.getSelectionIndex();
			NetworkNodePair nwnPair = controller.getNetworkNodePairs().get(index);
			((RefactoringDataManagement) this.controller.getDataManagementObject()).
						getInPortByName("selectedEObject").setValue(nwnPair.getNode1());
			((RefactoringDataManagement) this.controller.getDataManagementObject()).
						getInPortByName("node2").setValue(nwnPair.getNode2());
			nwnPairWidget.setEnabled(false);
			controller.setNetworkNodes(nwnPair);
			nwnWidget.clearSelection();
			for (int i = 0; i < controller.getNetworkNodes().size(); i++) {
				nwnWidget.add(controller.getNetworkNodes().get(i).getName());
		    }
			nwnWidget.setEnabled(true);
		}
		
		if (event.widget == nwnWidget) {
			int index = nwnWidget.getSelectionIndex();
			NetworkNode node = controller.getNetworkNodes().get(index);
			((RefactoringDataManagement) this.controller.getDataManagementObject()).
						getInPortByName("node").setValue(node);
		}
	}
	
	/**
	 * @see org.eclipse.jface.dialogs.IDialogPage#
	 * createControl(org.eclipse.swt.widgets.Composite)
	 * @generated
	 */
	@Override
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout gl = new GridLayout();
		gl.numColumns = 2;
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		composite.setLayout(gl);			
		
		nwnPairLabel = new Label(composite, SWT.NONE);
		nwnPairLabel.setText("Network Nodes to be merged: ");
		nwnPairLabel.setEnabled(true);
		
		nwnPairWidget = new Combo(composite, SWT.DROP_DOWN | SWT.BORDER);	
		nwnPairWidget.setToolTipText("Network Nodes to be merged");
		nwnPairWidget.setEnabled(true);
		nwnPairWidget.setLayoutData(gd);
		nwnPairWidget.addListener(SWT.Modify, this);
		
		for (int i = 0; i < controller.getNetworkNodePairs().size(); i++) {
			nwnPairWidget.add(controller.getNetworkNodePairs().get(i).toString());
	    }	
		
		nwnLabel = new Label(composite, SWT.NONE);
		nwnLabel.setText("Network Node to be used instead: ");
		nwnLabel.setEnabled(true);
		
		nwnWidget = new Combo(composite, SWT.DROP_DOWN | SWT.BORDER);	
		nwnWidget.setToolTipText("Network Node to be used instead");
		nwnWidget.setEnabled(false);
		nwnWidget.setLayoutData(gd);
		nwnWidget.addListener(SWT.Modify, this);
		
		setControl(composite);
	}
	
}
	