/**
 * <copyright>
 * </copyright>
 *
 * $Id: RefactoringWizardPageHenshin.javajet,v 1.2 2012/11/26 15:39:38 tarendt Exp $
 */
 package pam.refactorings.pam.substituteclientnode;

import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

import PAM.ClientNode;

/**
 * Class for setting model refactoring specific parameters
 * by the user.
 * @generated
 */
public class RefactoringWizardPage extends 
				UserInputWizardPage implements Listener {
				
	/**
	 * Controller of the EMF model refactoring.
	 * @generated
	 */			
	private final RefactoringController controller;
	
	/**
	 * Label for each parameter.
	 * @generated
	 */
	private Label clientLabel;
	
	private Combo clientWidget;

	/**
	 * Default constructor using a name and the controller of the 
	 * EMF model refactoring.
	 * @param name Name of the WizardPage.
	 * @param controller Controller of the EMF model refactoring.
	 * @generated
	 */
	public RefactoringWizardPage
		(String name, RefactoringController controller) {
		super(name);
		this.controller = controller;
	}

	/**
	 * @see org.eclipse.swt.widgets.Listener#
	 * handleEvent(org.eclipse.swt.widgets.Event)
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void handleEvent(Event event) {		
		getWizard().getContainer().updateButtons();
				
		if (clientWidget != null) {
			int index = clientWidget.getSelectionIndex();
			ClientNode client = controller.getClientNodes().get(index);
			if (client != null) {
				((RefactoringDataManagement) 
						this.controller.getDataManagementObject()).
						getInPortByName("client").
						setValue(client);
			} else {
				((RefactoringDataManagement) 
						this.controller.getDataManagementObject()).
						getInPortByName("client").
						setValue("unspecified");
			}
		}

	}
	
	/**
	 * @see org.eclipse.jface.dialogs.IDialogPage#
	 * createControl(org.eclipse.swt.widgets.Composite)
	 * @generated
	 */
	@Override
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout gl = new GridLayout();
		gl.numColumns = 2;
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		composite.setLayout(gl);
			
		
		clientLabel = new Label(composite, SWT.NONE);
		clientLabel.setText("Client node to be substituted with: ");
		clientLabel.setEnabled(true);
		
		clientWidget = new Combo(composite, SWT.DROP_DOWN | SWT.BORDER);	
		clientWidget.setToolTipText("Client node to be substituted with");
		clientWidget.setEnabled(true);
		clientWidget.setLayoutData(gd);
		clientWidget.addListener(SWT.Modify, this);
		
		for (int i = 0; i < controller.getClientNodes().size(); i++) {
			clientWidget.add(controller.getClientNodes().get(i).getName());
	    }	
		
		setControl(composite);
	}
	
}
	