/**
 * <copyright>
 * </copyright>
 *
 * $Id: RefactoringController.java,v 1.2 2011/01/20 13:43:01 tarendt Exp $
 */
 package org.eclipse.emf.refactor.refactorings.ecore.pushdowneattribute;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.refactor.refactoring.core.Refactoring;
import org.eclipse.emf.refactor.refactoring.interfaces.IController;
import org.eclipse.emf.refactor.refactoring.interfaces.IDataManagement;
import org.eclipse.emf.refactor.refactoring.runtime.ltk.LtkEmfRefactoringProcessorAdapter;
import org.eclipse.emf.refactor.refactorings.ecore.RefactoringHelper;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;

public final class RefactoringController implements IController{

	/**
	 * Refactoring supported by the controller.
	 * @generated
	 */
	private Refactoring parent;
	
	/**
	 * DataManagement object of the model refactoring.
	 * @generated
	 */
	private RefactoringDataManagement dataManagement = 
									new RefactoringDataManagement();
	
	/**
	 * Invocation context of the model refactoring.
	 * @generated
	 */	
	private List<EObject> selection = new ArrayList<EObject>();
	
	/**
	 * Ltk RefactoringProcessor of the model refactoring.
	 * @generated
	 */
	private InternalRefactoringProcessor refactoringProcessor = null;
	
	/**
	 * Gets the Refactoring supported by the controller.
	 * @return Refactoring supported by the controller.
	 * @see org.eclipse.emf.refactor.common.core.IController#getParent()
	 * @generated
	 */
	@Override
	public Refactoring getParent() {
		return this.parent;
	}
	
	/**
	 * Sets the Refactoring supported by the controller.
	 * @param emfRefactoring Refactoring supported by the controller.
	 * @see org.eclipse.emf.refactor.common.core.IController#
	 * setParent(org.eclipse.emf.refactor.common.core.Refactoring)
	 * @generated
	 */
	@Override
	public void setParent(Refactoring emfRefactoring) {
		this.parent = emfRefactoring;
	}
	
	/**
	 * Returns the DataManagement object of the model refactoring.
	 * @return DataManagement object of the model refactoring.
	 * @see org.eclipse.emf.refactor.henshin.core.IHenshinController#
	 * getDataManagementObject()
	 * @generated
	 */
	@Override
	public IDataManagement getDataManagementObject() {
		return this.dataManagement;
	}

	/**
	 * Returns the ltk RefactoringProcessor of the model refactoring.
	 * @return Ltk RefactoringProcessor of the model refactoring.
	 * @see org.eclipse.emf.refactor.common.core.IController#
	 * getLtkRefactoringProcessor()
	 * @generated
	 */
	@Override
	public RefactoringProcessor getLtkRefactoringProcessor() {
		return this.refactoringProcessor;
	}
	
	/**
	 * Sets the selected EObject (invocation context of the model refactoring).
	 * @param selection Invocation context of the model refactoring.
	 * @see org.eclipse.emf.refactor.common.core.IController#
	 * setSelection(java.util.List)
	 * @generated
	 */
	@Override
	public void setSelection(List<EObject> selection) {
		this.selection = selection;
		this.refactoringProcessor = 
				new InternalRefactoringProcessor(this.selection);
	}	
	
	/**
	 * Returns a Runnable object that executes the model refactoring.
	 * @return Runnable object that executes the model refactoring.
	 * @generated
	 */
	private Runnable applyRefactoring() {
		return new Runnable() {				
			/**
			 * @see java.lang.Runnable#run()
			 * @generated
			 */
			@Override
			public void run() {
				// begin custom code
				EAttribute selectedEAttribute = (EAttribute) dataManagement.
					getInPortByName(dataManagement.SELECTEDEOBJECT).getValue();
				// copy the selected EAttribute to each subEClass
				EClass containingEClass = selectedEAttribute.getEContainingClass();
				EList <EClass> eSubClasses = 
											RefactoringHelper.getESubClasses(containingEClass);
				for (EClass eClass : eSubClasses) {
					EAttribute eAttributeCopy = 
												(EAttribute) EcoreUtil.copy(selectedEAttribute);
					eClass.getEStructuralFeatures().add(eAttributeCopy);
				}
				// remove the selected EAttribute from its containing EClass
				containingEClass.getEStructuralFeatures().remove(selectedEAttribute);
				// end custom code
			}
		};
	}

	/**
	 * Internal class for providing an instance of a LTK RefactoringProcessor 
	 * used for EMF model refactorings using Henshin transformations.	 
	 * @generated
	 */
	public final class InternalRefactoringProcessor extends 
									LtkEmfRefactoringProcessorAdapter {

		/**
		 * Constructor using the invocation context of the model refactoring.
		 * @param selection Invocation context of the model refactoring.
		 * @generated
		 */
		private InternalRefactoringProcessor(List<EObject> selection){
				super(getParent(), selection, applyRefactoring());				
		}
			
		/**
		 * @see org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor#
	 	 * checkInitialConditions(org.eclipse.core.runtime.IProgressMonitor)
		 * @generated
		 */	
		@Override
		public RefactoringStatus checkInitialConditions(){
				RefactoringStatus result = new RefactoringStatus();
				// begin custom code
				EAttribute selectedEAttribute = (EAttribute) dataManagement.
					getInPortByName(dataManagement.SELECTEDEOBJECT).getValue();
				// initial check 1: the containing EClass of the selected EAttribute must
				// have eSubClasses
				EClass containingEClass = selectedEAttribute.getEContainingClass();
				EList <EClass> eSubClasses = 
											RefactoringHelper.getESubClasses(containingEClass);
				if (eSubClasses.isEmpty()) {
					result.addFatalError("EClass '" + containingEClass.getName() + 
													"' is not eSuperType of another EClass!");
				}
				// initial check 2: each sub EClass of the containing EClass must not
				// have an EStructuralFeature (inherited by another super EClass) with 
				// the same name as the selected EAttribute
				for (EClass eSubClass : eSubClasses) {
					for (EStructuralFeature eStrFeat : 
								eSubClass.getEAllStructuralFeatures()) {
						if (eStrFeat != selectedEAttribute && 
								eStrFeat.getName().equals(selectedEAttribute.getName())) {
							result.addFatalError("Sub EClass '" + eSubClass.getName() + 
										"' already contains an EStructuralFeature named '" + 
										selectedEAttribute.getName() +"'!");
						}
					}
				}				
				// end custom code
				return result;
		}
		
		/**
		 * @see org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor#
	     * checkFinalConditions(org.eclipse.core.runtime.IProgressMonitor, 
	     * org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext)
		 * @generated
		 */	
		@Override
		public RefactoringStatus checkFinalConditions(){
				RefactoringStatus result = new RefactoringStatus();
				// this refactoring has no final checks
				return result;
		}
		
	}

}