/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ide.editor.view;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class UnknownFeaturesDialog
extends Dialog {
    protected final Map<EObject, AnyType> objects;
    protected String description;
    private final String title;

    protected UnknownFeaturesDialog(Shell parentShell, String title, Map<EObject, AnyType> objects) {
        super(parentShell);
        this.objects = objects;
        this.title = title;
        this.setDescription("The following features could not be migrated:");
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 64);
        label.setText(this.getDescription());
        TableViewer viewer = new TableViewer(parent, 2820);
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        table.setToolTipText("");
        Listener tableListener = this.getTableListener(composite, table);
        table.addListener(12, tableListener);
        table.addListener(1, tableListener);
        table.addListener(5, tableListener);
        table.addListener(32, tableListener);
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        viewer.setInput(this.getInput());
        this.createColumns(parent, viewer);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        viewer.getControl().setLayoutData((Object)gridData);
        viewer.refresh(true);
        composite.layout();
        return composite;
    }

    private Listener getLabelListener(final Table table) {
        return new Listener(){

            public void handleEvent(Event event) {
                Text label = (Text)event.widget;
                Shell shell = label.getShell();
                switch (event.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = (TableItem)label.getData("_TABLEITEM");
                        table.setSelection(new TableItem[]{(TableItem)e.item});
                        table.notifyListeners(13, e);
                        shell.dispose();
                        table.setFocus();
                        break;
                    }
                    case 7: {
                        shell.dispose();
                        break;
                    }
                }
            }
        };
    }

    private Listener getTableListener(final Composite composite, final Table table) {
        return new Listener(){
            Shell tip = null;
            Text text = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 5: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.text = null;
                        break;
                    }
                    case 32: {
                        TableItem item = table.getItem(new Point(event.x, event.y));
                        if (item == null) break;
                        if (this.tip != null && !this.tip.isDisposed()) {
                            this.tip.dispose();
                        }
                        this.tip = new Shell(composite.getShell(), 540676);
                        this.tip.setBackground(composite.getDisplay().getSystemColor(29));
                        FillLayout layout = new FillLayout();
                        layout.marginWidth = 2;
                        this.tip.setLayout((Layout)layout);
                        this.text = new Text((Composite)this.tip, 2);
                        this.text.setForeground(composite.getDisplay().getSystemColor(28));
                        this.text.setBackground(composite.getDisplay().getSystemColor(29));
                        this.text.setData("_TABLEITEM", (Object)item);
                        this.text.setText(item.getText());
                        this.text.setEditable(false);
                        this.text.addListener(7, UnknownFeaturesDialog.this.getLabelListener(table));
                        Point size = this.tip.computeSize(-1, -1);
                        Rectangle rect = item.getBounds(0);
                        Point pt = table.toDisplay(rect.x, rect.y);
                        this.tip.setBounds(pt.x, pt.y, size.x, size.y);
                        this.tip.setVisible(true);
                        break;
                    }
                }
            }
        };
    }

    private List<InputElement> getInput() {
        ArrayList<InputElement> input = new ArrayList<InputElement>();
        for (Map.Entry<EObject, AnyType> entry : this.objects.entrySet()) {
            AnyType value = entry.getValue();
            FeatureMap mixed = value.getMixed();
            int i = 0;
            while (i < mixed.size()) {
                AnyType object = (AnyType)mixed.getValue(i);
                FeatureMap anyAttribute2 = object.getAnyAttribute();
                FeatureMap mixed2 = object.getMixed();
                int i1 = 0;
                while (i1 < anyAttribute2.size()) {
                    String vvalue = (String)anyAttribute2.getValue(i1);
                    input.add(new InputElement(object.eClass().getName(), vvalue));
                    vvalue.toString();
                    ++i1;
                }
                i1 = 0;
                while (i1 < mixed2.size()) {
                    if (AnyType.class.isInstance(mixed2.getValue(i1))) {
                        String value2 = mixed2.getEStructuralFeature(i1).getName();
                        String object2 = mixed2.getValue(i1).toString();
                        input.add(new InputElement(object2, value2));
                    }
                    ++i1;
                }
                ++i;
            }
        }
        return input;
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        String[] titles = new String[]{"Type", "Name", ""};
        int[] bounds = new int[]{200, 200};
        TableColumn[] tableColumnArray = viewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.dispose();
            ++n2;
        }
        TableViewerColumn col = this.createTableViewerColumn(viewer, titles[0], bounds[0], 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                InputElement inputEl = (InputElement)element;
                return inputEl.getObjectType();
            }
        });
        col = this.createTableViewerColumn(viewer, titles[1], bounds[1], 1);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                InputElement inputEl = (InputElement)element;
                return inputEl.getObjectName();
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(TableViewer viewer, String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    public boolean close() {
        return super.close();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    private class InputElement {
        private final String objectType;
        private final String objectName;

        public String getObjectType() {
            return this.objectType;
        }

        public String getObjectName() {
            return this.objectName;
        }

        InputElement(String type, String name) {
            this.objectType = type;
            this.objectName = name;
        }
    }
}

