/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.core.swt.renderer;

import java.util.Set;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.core.swt.Activator;
import org.eclipse.emf.ecp.view.internal.core.swt.renderer.RendererMessages;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.provider.ECPTooltipModifierHelper;
import org.eclipse.emf.ecp.view.spi.swt.SWTRendererFactory;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridCell;
import org.eclipse.emf.ecp.view.template.model.VTStyleProperty;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.ecp.view.template.style.alignment.model.AlignmentType;
import org.eclipse.emf.ecp.view.template.style.alignment.model.VTAlignmentStyleProperty;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TextControlSWTRenderer
extends SimpleControlSWTControlSWTRenderer {
    public TextControlSWTRenderer() {
    }

    TextControlSWTRenderer(SWTRendererFactory factory) {
        super(factory);
    }

    @Override
    protected Binding[] createBindings(Control control, EStructuralFeature.Setting setting) {
        TargetToModelUpdateStrategy targetToModelUpdateStrategy = new TargetToModelUpdateStrategy(setting.getEStructuralFeature().isUnsettable());
        ModelToTargetUpdateStrategy modelToTargetUpdateStrategy = new ModelToTargetUpdateStrategy(false);
        Binding binding = this.bindValue(control, this.getModelValue(setting), this.getDataBindingContext(), (UpdateValueStrategy)targetToModelUpdateStrategy, (UpdateValueStrategy)modelToTargetUpdateStrategy);
        Binding tooltipBinding = this.createTooltipBinding(control, this.getModelValue(setting), this.getDataBindingContext(), (UpdateValueStrategy)targetToModelUpdateStrategy, (UpdateValueStrategy)new ModelToTargetUpdateStrategy(true));
        return new Binding[]{binding, tooltipBinding};
    }

    @Override
    protected Control createSWTControl(Composite parent, EStructuralFeature.Setting setting) {
        Text text = new Text(parent, this.getTextWidgetStyle());
        text.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getTextVariantID());
        text.setMessage(this.getTextMessage(setting));
        return text;
    }

    protected String getTextMessage(EStructuralFeature.Setting setting) {
        return this.getItemPropertyDescriptor(setting).getDisplayName(null);
    }

    protected Binding bindValue(Control text, IObservableValue modelValue, DataBindingContext dataBindingContext, UpdateValueStrategy targetToModel, UpdateValueStrategy modelToTarget) {
        ISWTObservableValue value = SWTObservables.observeText((Control)text, (int)16);
        Binding binding = dataBindingContext.bindValue((IObservableValue)value, modelValue, targetToModel, modelToTarget);
        return binding;
    }

    protected Binding createTooltipBinding(Control text, IObservableValue modelValue, DataBindingContext dataBindingContext, UpdateValueStrategy targetToModel, UpdateValueStrategy modelToTarget) {
        ISWTObservableValue toolTip = SWTObservables.observeTooltipText((Control)text);
        return dataBindingContext.bindValue((IObservableValue)toolTip, modelValue, targetToModel, modelToTarget);
    }

    protected int getTextWidgetStyle() {
        int textStyle = 2052;
        if (this.getItemPropertyDescriptor((EStructuralFeature.Setting)((VControl)this.getVElement()).getDomainModelReference().getIterator().next()).isMultiLine(null)) {
            textStyle = 2882;
        }
        return textStyle |= this.getAlignment();
    }

    private int getAlignment() {
        VTViewTemplateProvider vtViewTemplateProvider = Activator.getDefault().getVTViewTemplateProvider();
        if (vtViewTemplateProvider == null) {
            return this.getDefaultAlignment();
        }
        Set styleProperties = vtViewTemplateProvider.getStyleProperties(this.getVElement(), this.getViewModelContext());
        for (VTStyleProperty styleProperty : styleProperties) {
            if (!VTAlignmentStyleProperty.class.isInstance(styleProperty)) continue;
            if (((VTAlignmentStyleProperty)VTAlignmentStyleProperty.class.cast(styleProperty)).getType() == AlignmentType.LEFT) {
                return 16384;
            }
            if (((VTAlignmentStyleProperty)VTAlignmentStyleProperty.class.cast(styleProperty)).getType() != AlignmentType.RIGHT) continue;
            return 131072;
        }
        return this.getDefaultAlignment();
    }

    protected int getDefaultAlignment() {
        return 16384;
    }

    protected String getTextVariantID() {
        return "org_eclipse_emf_ecp_control_string";
    }

    @Override
    protected void setControlEnabled(SWTGridCell gridCell, Control control, boolean enabled) {
        if (((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.NONE && gridCell.getColumn() == 1 || ((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.LEFT && gridCell.getColumn() == 2) {
            EStructuralFeature feature = (EStructuralFeature)((VControl)this.getVElement()).getDomainModelReference().getEStructuralFeatureIterator().next();
            Control controlToUnset = control;
            if (feature.isUnsettable()) {
                controlToUnset = ((Composite)Composite.class.cast(((Composite)Composite.class.cast(control)).getChildren()[0])).getChildren()[0];
            }
            ((Text)Text.class.cast(controlToUnset)).setEditable(enabled);
        } else {
            super.setControlEnabled(gridCell, control, enabled);
        }
    }

    @Override
    protected String getUnsetText() {
        return RendererMessages.StringControl_NoTextSetClickToSetText;
    }

    class EMFUpdateConvertValueStrategy
    extends EMFUpdateValueStrategy {
        public Object convert(Object value) {
            return this.convertValue(value);
        }

        protected Object convertValue(Object value) {
            return super.convert(value);
        }
    }

    protected class ModelToTargetUpdateStrategy
    extends EMFUpdateConvertValueStrategy {
        private final boolean tooltip;

        public ModelToTargetUpdateStrategy(boolean tooltip) {
            this.tooltip = tooltip;
        }

        @Override
        public Object convert(Object value) {
            Object converted = this.convertValue(value);
            if (this.tooltip && String.class.isInstance(converted)) {
                return ECPTooltipModifierHelper.modifyString((String)((String)String.class.cast(converted)), (EStructuralFeature.Setting)((EStructuralFeature.Setting)((VControl)TextControlSWTRenderer.this.getVElement()).getDomainModelReference().getIterator().next()));
            }
            return converted;
        }
    }

    protected class TargetToModelUpdateStrategy
    extends EMFUpdateConvertValueStrategy {
        private final boolean unsetable;

        public TargetToModelUpdateStrategy(boolean unsettable) {
            this.unsetable = unsettable;
        }

        @Override
        public Object convert(Object value) {
            if ("".equals(value)) {
                value = null;
            }
            if (value == null && this.unsetable) {
                return SetCommand.UNSET_VALUE;
            }
            return this.convertValue(value);
        }
    }
}

