/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.core.swt;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecp.view.internal.core.swt.Activator;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VContainer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.model.reporting.AbstractReport;
import org.eclipse.emf.ecp.view.spi.model.reporting.ReportService;
import org.eclipse.emf.ecp.view.spi.model.reporting.StatusReport;
import org.eclipse.emf.ecp.view.spi.model.util.ViewModelUtil;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.AbstractAdditionalSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.SWTRendererFactory;
import org.eclipse.emf.ecp.view.spi.swt.layout.GridDescriptionFactory;
import org.eclipse.emf.ecp.view.spi.swt.layout.LayoutProviderHelper;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridCell;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridDescription;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class ContainerSWTRenderer<VELEMENT extends VElement>
extends AbstractSWTRenderer<VELEMENT> {
    private SWTGridDescription rendererGridDescription;

    public ContainerSWTRenderer() {
    }

    protected ContainerSWTRenderer(SWTRendererFactory factory) {
        super(factory);
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
        }
        return this.rendererGridDescription;
    }

    protected Control renderControl(SWTGridCell gridCell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        if (gridCell.getColumn() != 0) {
            return null;
        }
        ReportService reportService = Activator.getDefault().getReportService();
        Composite columnComposite = this.getComposite(parent);
        columnComposite.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getCustomVariant());
        columnComposite.setBackground(parent.getBackground());
        LinkedHashMap elementRendererMap = new LinkedHashMap();
        SWTGridDescription maximalGridDescription = null;
        LinkedHashMap<VContainedElement, SWTGridDescription> rowGridDescription = new LinkedHashMap<VContainedElement, SWTGridDescription>();
        LinkedHashMap<VContainedElement, SWTGridDescription> controlGridDescription = new LinkedHashMap<VContainedElement, SWTGridDescription>();
        for (VContainedElement child : this.getChildren()) {
            if (VControl.class.isInstance(child) && (((VControl)VControl.class.cast(child)).getDomainModelReference() == null || !((VControl)VControl.class.cast(child)).getDomainModelReference().getIterator().hasNext())) continue;
            AbstractSWTRenderer renderer = this.getSWTRendererFactory().getRenderer((VElement)child, this.getViewModelContext());
            if (renderer == null) {
                reportService.report((AbstractReport)new StatusReport(new Status(1, "org.eclipse.emf.ecp.view.core.swt", String.format("No Renderer for %s found.", child.eClass().getName()))));
                continue;
            }
            Collection additionalRenderers = this.getSWTRendererFactory().getAdditionalRenderer((VElement)child, this.getViewModelContext());
            SWTGridDescription gridDescription = renderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription());
            controlGridDescription.put(child, gridDescription);
            for (AbstractAdditionalSWTRenderer additionalRenderer : additionalRenderers) {
                gridDescription = additionalRenderer.getGridDescription(gridDescription);
            }
            rowGridDescription.put(child, gridDescription);
            if (maximalGridDescription == null || maximalGridDescription.getColumns() < gridDescription.getColumns()) {
                maximalGridDescription = gridDescription;
            }
            LinkedHashSet<AbstractSWTRenderer> allRenderer = new LinkedHashSet<AbstractSWTRenderer>();
            allRenderer.add(renderer);
            allRenderer.addAll(additionalRenderers);
            elementRendererMap.put(child, allRenderer);
        }
        if (maximalGridDescription == null) {
            return columnComposite;
        }
        columnComposite.setLayout(this.getLayout(maximalGridDescription.getColumns(), false));
        for (VContainedElement child : this.getChildren()) {
            SWTGridDescription gridDescription;
            if (VControl.class.isInstance(child) && (((VControl)VControl.class.cast(child)).getDomainModelReference() == null || !((VControl)VControl.class.cast(child)).getDomainModelReference().getIterator().hasNext()) || (gridDescription = (SWTGridDescription)rowGridDescription.get(child)) == null) continue;
            for (SWTGridCell childGridCell : gridDescription.getGrid()) {
                Control control;
                block13: {
                    control = null;
                    try {
                        control = ((AbstractSWTRenderer)childGridCell.getRenderer()).render(childGridCell, columnComposite);
                    }
                    catch (NoRendererFoundException ex) {
                        reportService.report((AbstractReport)new RenderingFailedReport((Throwable)ex));
                        if (ViewModelUtil.isDebugMode()) {
                            control = this.renderDiagnoseControl(columnComposite, child);
                        }
                    }
                    catch (NoPropertyDescriptorFoundExeption ex) {
                        reportService.report((AbstractReport)new RenderingFailedReport((Throwable)ex));
                        if (!ViewModelUtil.isDebugMode()) break block13;
                        control = this.renderDiagnoseControl(columnComposite, child);
                    }
                }
                if (control == null) continue;
                this.setLayoutDataForControl(childGridCell, (SWTGridDescription)controlGridDescription.get(child), gridDescription, maximalGridDescription, ((AbstractSWTRenderer)childGridCell.getRenderer()).getVElement(), control);
            }
            for (SWTGridCell childGridCell : gridDescription.getGrid()) {
                ((AbstractSWTRenderer)childGridCell.getRenderer()).finalizeRendering(columnComposite);
            }
        }
        return columnComposite;
    }

    private Control renderDiagnoseControl(Composite parent, VContainedElement child) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        Composite composite = new Composite(parent, 2048);
        composite.setLayout((Layout)new FillLayout());
        Label label = new Label(composite, 0);
        label.setForeground(Display.getDefault().getSystemColor(3));
        label.setText("An error occurred while rendering " + child.getClass().getCanonicalName());
        return composite;
    }

    protected String getCustomVariant() {
        return "org_eclipse_emf_ecp_view_container";
    }

    protected Collection<VContainedElement> getChildren() {
        if (VViewPackage.eINSTANCE.getContainer().isInstance((Object)this.getVElement())) {
            return ((VContainer)VContainer.class.cast(this.getVElement())).getChildren();
        }
        return Collections.emptySet();
    }

    protected Composite getComposite(Composite parent) {
        return new Composite(parent, 0);
    }

    protected Layout getLayout(int numControls, boolean equalWidth) {
        return LayoutProviderHelper.getColumnLayout((int)numControls, (boolean)equalWidth);
    }

    protected void dispose() {
        this.rendererGridDescription = null;
        super.dispose();
    }
}

