/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.generalization;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.common.MetamodelFactory;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="specializeComposition", label="Specialize Composition", description="In the metamodel, the type of a containment reference is specialized by a new sub class. In the model, the values of this reference are migrated to the new type.")
public class SpecializeComposition
extends OperationImplementation {
    @EdaptParameter(main=true, description="The containment reference to be specialized")
    public EReference reference;
    @EdaptParameter(description="The package in which the sub class is created")
    public EPackage ePackage;
    @EdaptParameter(description="The name of the sub class")
    public String name;

    @EdaptConstraint(restricts="reference", description="The reference has to be a containment reference")
    public boolean checkReference(EReference reference) {
        return reference.isContainment();
    }

    public void execute(Metamodel metamodel, Model model) {
        EClass superType = this.reference.getEReferenceType();
        EClass eClass = this.reference.getEContainingClass();
        EClass newType = MetamodelFactory.newEClass((EPackage)this.ePackage, (String)this.name, (EClass)superType);
        this.reference.setEType((EClassifier)newType);
        for (Instance instance : model.getAllInstances(eClass)) {
            if (!instance.isSet((EStructuralFeature)this.reference)) continue;
            Object value = instance.get((EStructuralFeature)this.reference);
            if (this.reference.isMany()) {
                List valueInstances = (List)value;
                for (Instance valueInstance : valueInstances) {
                    this.migrate(valueInstance, superType, newType, model);
                }
                continue;
            }
            if (value == null) continue;
            Instance valueInstance = (Instance)value;
            this.migrate(valueInstance, superType, newType, model);
        }
    }

    private void migrate(Instance valueInstance, EClass superType, EClass newType, Model model) {
        if (valueInstance.getEClass() == superType) {
            valueInstance.migrate(newType);
        } else {
            model.delete(valueInstance);
        }
    }
}

