/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.reconstruction;

import java.io.IOException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edapt.common.LoggingUtils;
import org.eclipse.emf.edapt.common.MetamodelExtent;
import org.eclipse.emf.edapt.common.ResourceUtils;
import org.eclipse.emf.edapt.history.reconstruction.EcoreReconstructorSwitchBase;
import org.eclipse.emf.edapt.history.reconstruction.ForwardReconstructorBase;
import org.eclipse.emf.edapt.history.reconstruction.Mapping;
import org.eclipse.emf.edapt.spi.history.Add;
import org.eclipse.emf.edapt.spi.history.Change;
import org.eclipse.emf.edapt.spi.history.CompositeChange;
import org.eclipse.emf.edapt.spi.history.Create;
import org.eclipse.emf.edapt.spi.history.Delete;
import org.eclipse.emf.edapt.spi.history.HistoryPlugin;
import org.eclipse.emf.edapt.spi.history.Move;
import org.eclipse.emf.edapt.spi.history.Remove;
import org.eclipse.emf.edapt.spi.history.Set;

public class EcoreForwardReconstructor
extends ForwardReconstructorBase {
    private final URI folder;
    private EcoreReconstructorSwitch ecoreSwitch;

    public EcoreForwardReconstructor(URI folder) {
        this.folder = folder;
    }

    public void init(Mapping mapping, MetamodelExtent extent) {
        this.ecoreSwitch = new EcoreReconstructorSwitch();
        super.init(mapping, extent);
    }

    public void startChange(Change change) {
        super.startChange(change);
        if (!(change instanceof Delete)) {
            this.ecoreSwitch.doSwitch(change);
        }
    }

    public void endChange(Change change) {
        if (change instanceof Delete) {
            this.ecoreSwitch.doSwitch(change);
        }
        super.endChange(change);
    }

    public void save() {
        try {
            ResourceUtils.saveResourceSet((ResourceSet)this.resourceSet);
        }
        catch (IOException e) {
            LoggingUtils.logError((Plugin)HistoryPlugin.getPlugin(), (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EcoreReconstructorSwitch
    extends EcoreReconstructorSwitchBase<Object> {
        private EcoreReconstructorSwitch() {
        }

        @Override
        public Object caseSet(Set operation) {
            EObject element = EcoreForwardReconstructor.this.mapping.getTarget(operation.getElement());
            EStructuralFeature feature = operation.getFeature();
            Object value = EcoreForwardReconstructor.this.mapping.resolveTarget(operation.getValue());
            this.set(element, feature, value);
            return operation;
        }

        @Override
        public Object caseCreate(Create operation) {
            EClass type = operation.getElement().eClass();
            EObject element = null;
            if (operation.getTarget() != null) {
                EObject target = EcoreForwardReconstructor.this.mapping.getTarget(operation.getTarget());
                EReference reference = operation.getReference();
                element = this.create(target, reference, type);
            } else {
                URI uri;
                Resource resource;
                element = type.getEPackage().getEFactoryInstance().create(type);
                String filename = operation.getElement().eResource().getURI().lastSegment();
                if (filename == null) {
                    filename = operation.getElement().eResource().getURI().toString();
                }
                if ((resource = EcoreForwardReconstructor.this.resourceSet.getResource(uri = EcoreForwardReconstructor.this.folder.appendSegment(filename), false)) == null) {
                    resource = EcoreForwardReconstructor.this.resourceSet.createResource(uri);
                }
                resource.getContents().add((Object)element);
            }
            EcoreForwardReconstructor.this.extent.addToExtent(element);
            EcoreForwardReconstructor.this.mapping.map(operation.getElement(), element);
            return operation;
        }

        @Override
        public Object caseDelete(Delete operation) {
            EObject element = EcoreForwardReconstructor.this.mapping.getTarget(operation.getElement());
            this.delete(element);
            return operation;
        }

        @Override
        public Object caseMove(Move operation) {
            EObject element = EcoreForwardReconstructor.this.mapping.getTarget(operation.getElement());
            EObject target = EcoreForwardReconstructor.this.mapping.getTarget(operation.getTarget());
            EReference reference = operation.getReference();
            this.move(element, target, reference);
            return operation;
        }

        @Override
        public Object caseAdd(Add operation) {
            EObject element = EcoreForwardReconstructor.this.mapping.getTarget(operation.getElement());
            Object value = EcoreForwardReconstructor.this.mapping.resolveTarget(operation.getValue());
            EStructuralFeature feature = operation.getFeature();
            this.add(element, feature, value);
            return operation;
        }

        @Override
        public Object caseRemove(Remove operation) {
            EObject element = EcoreForwardReconstructor.this.mapping.getTarget(operation.getElement());
            Object value = EcoreForwardReconstructor.this.mapping.resolveTarget(operation.getValue());
            EStructuralFeature feature = operation.getFeature();
            this.remove(element, feature, value);
            return operation;
        }

        @Override
        public Object caseCompositeChange(CompositeChange operation) {
            return operation;
        }
    }
}

