/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.filetransfer;

import org.eclipse.emf.emfstore.internal.client.model.filetransfer.FileTransferManager;
import org.eclipse.emf.emfstore.internal.server.model.FileIdentifier;

public class FileInformation {
    private FileIdentifier fileId;
    private FileTransferManager transferManager;

    FileInformation(FileIdentifier fileId, FileTransferManager transferManager) {
        this.fileId = fileId;
        this.transferManager = transferManager;
    }

    public boolean isCached() {
        return this.transferManager.getCache().hasCachedFile(this.fileId);
    }

    public boolean isPendingUpload() {
        return this.transferManager.hasWaitingUpload(this.fileId);
    }

    public void cancelPendingUpload() {
        if (!this.isPendingUpload()) {
            return;
        }
        this.transferManager.cancelPendingUpload(this.fileId);
    }
}

