/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.template.tooling.editor;

import java.io.IOException;
import java.util.EventObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecp.edit.spi.EMFDeleteServiceImpl;
import org.eclipse.emf.ecp.internal.ide.util.EcoreHelper;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.DefaultReferenceService;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.model.common.edit.provider.CustomReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContextFactory;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.ecp.view.template.internal.tooling.Activator;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplate;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class TemplateModelEditorPart
extends EditorPart {
    private VTViewTemplate template;
    private BasicCommandStack basicCommandStack;
    private Composite parent;
    private Resource resource;

    public void doSave(IProgressMonitor monitor) {
        try {
            this.resource.save(null);
            this.basicCommandStack.saveIsDone();
            this.firePropertyChange(257);
        }
        catch (IOException e) {
            Activator.log(e);
        }
    }

    public void doSaveAs() {
    }

    private ResourceSet createResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)new ComposedAdapterFactory(new AdapterFactory[]{new CustomReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)}), (CommandStack)this.basicCommandStack, (ResourceSet)resourceSet);
        resourceSet.eAdapters().add((Object)new AdapterFactoryEditingDomain.EditingDomainProvider((EditingDomain)domain));
        return resourceSet;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.setSite((IWorkbenchPartSite)site);
        super.setInput(input);
        super.setPartName(input.getName());
        this.basicCommandStack = new BasicCommandStack();
        this.basicCommandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                TemplateModelEditorPart.this.parent.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TemplateModelEditorPart.this.firePropertyChange(257);
                    }
                });
            }
        });
        FileEditorInput fei = (FileEditorInput)this.getEditorInput();
        ResourceSet resourceSet = this.createResourceSet();
        try {
            this.resource = resourceSet.createResource(URI.createURI((String)fei.getURI().toURL().toExternalForm()));
            this.resource.load(null);
            this.template = (VTViewTemplate)this.resource.getContents().get(0);
            for (String ecorePath : this.template.getReferencedEcores()) {
                EcoreHelper.registerEcore((String)ecorePath);
            }
        }
        catch (IOException e) {
            Activator.log(e);
        }
    }

    public void dispose() {
        for (String ecorePath : this.template.getReferencedEcores()) {
            EcoreHelper.unregisterEcore((String)ecorePath);
        }
        super.dispose();
    }

    public boolean isDirty() {
        return this.basicCommandStack.isSaveNeeded();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setBackground(parent.getDisplay().getSystemColor(1));
        VView view = ViewProviderHelper.getView((EObject)this.template, null);
        ViewModelContext viewContext = ViewModelContextFactory.INSTANCE.createViewModelContext((VElement)view, (EObject)this.template, new ViewModelService[]{new DefaultReferenceService(), new EMFDeleteServiceImpl()});
        try {
            ECPSWTViewRenderer.INSTANCE.render(parent, viewContext);
        }
        catch (ECPRendererException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
        }
    }

    public void setFocus() {
    }
}

