/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.treemasterdetail.internal.validation;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.model.common.edit.provider.CustomReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.ecp.view.spi.context.GlobalViewModelService;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.model.util.ViewModelPropertiesHelper;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.ecp.view.treemasterdetail.model.VTreeMasterDetail;
import org.eclipse.emf.ecp.view.treemasterdetail.ui.swt.internal.RootObject;
import org.eclipse.emf.ecp.view.treemasterdetail.ui.swt.internal.TreeMasterDetailSelectionManipulatorHelper;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;

public class TreeMasterDetailValidationInitiator
implements GlobalViewModelService {
    private final Map<TreeContextMapping, Set<Object>> mapping = new LinkedHashMap<TreeContextMapping, Set<Object>>();
    public static final String DETAIL_KEY = "detail";
    public static final String ROOT_KEY = "root";
    private ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new CustomReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
    private AdapterFactoryContentProvider adapterFactoryContentProvider = new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory){

        public Object[] getElements(Object object) {
            return new Object[]{((RootObject)object).getRoot()};
        }
    };

    public void instantiate(ViewModelContext context) {
        context.registerDomainChangeListener((ModelChangeListener)new TreeMasterDetailValidationInitiatorDomainChangeListener(context));
        this.checkForTreeMasterDetail(context);
    }

    private void checkForTreeMasterDetail(ViewModelContext context) {
        VElement viewRoot = context.getViewModel();
        TreeIterator eAllContents = viewRoot.eAllContents();
        while (eAllContents.hasNext()) {
            EObject eObject = (EObject)eAllContents.next();
            if (!VTreeMasterDetail.class.isInstance(eObject)) continue;
            VTreeMasterDetail treeMasterDetail = (VTreeMasterDetail)VTreeMasterDetail.class.cast(eObject);
            this.registerRootChildContext(treeMasterDetail, context);
            this.registerChildrenChildContext(treeMasterDetail, context, this.adapterFactoryContentProvider);
        }
    }

    private void registerChildrenChildContext(VTreeMasterDetail treeMasterDetail, ViewModelContext viewModelContext, AdapterFactoryContentProvider adapterFactoryContentProvider) {
        Set<Object> children = this.getAllChildren(viewModelContext.getDomainModel(), adapterFactoryContentProvider);
        for (Object object : children) {
            VElement viewModel = viewModelContext.getViewModel();
            VViewModelProperties properties = ViewModelPropertiesHelper.getInhertitedPropertiesOrEmpty((VElement)viewModel);
            properties.addNonInheritableProperty(DETAIL_KEY, (Object)true);
            EObject manipulateSelection = (EObject)this.manipulateSelection(object);
            TreeContextMapping entry = new TreeContextMapping();
            entry.context = viewModelContext;
            entry.control = treeMasterDetail;
            if (!this.mapping.containsKey(entry)) {
                this.mapping.put(entry, new LinkedHashSet());
            }
            this.mapping.get(entry).add(manipulateSelection);
            VView view = ViewProviderHelper.getView((EObject)manipulateSelection, (VViewModelProperties)properties);
            ViewModelContext childContext = viewModelContext.getChildContext(manipulateSelection, (VElement)treeMasterDetail, view, new ViewModelService[0]);
            childContext.addContextUser((Object)this);
        }
    }

    private void registerRootChildContext(VTreeMasterDetail treeMasterDetail, ViewModelContext viewModelContext) {
        VElement viewModel = viewModelContext.getViewModel();
        VViewModelProperties properties = ViewModelPropertiesHelper.getInhertitedPropertiesOrEmpty((VElement)viewModel);
        properties.addNonInheritableProperty(DETAIL_KEY, (Object)true);
        properties.addNonInheritableProperty(ROOT_KEY, (Object)true);
        Object manipulateSelection = this.manipulateSelection(viewModelContext.getDomainModel());
        TreeContextMapping entry = new TreeContextMapping();
        entry.context = viewModelContext;
        entry.control = treeMasterDetail;
        if (!this.mapping.containsKey(entry)) {
            this.mapping.put(entry, new LinkedHashSet());
        }
        this.mapping.get(entry).add(manipulateSelection);
        VView view = treeMasterDetail.getDetailView();
        if (view == null || view.getChildren().isEmpty()) {
            view = ViewProviderHelper.getView((EObject)((EObject)manipulateSelection), (VViewModelProperties)properties);
        }
        ViewModelContext childContext = viewModelContext.getChildContext((EObject)manipulateSelection, (VElement)treeMasterDetail, view, new ViewModelService[0]);
        childContext.addContextUser((Object)this);
    }

    private Set<Object> getAllChildren(Object parent, AdapterFactoryContentProvider adapterFactoryContentProvider) {
        Object[] children;
        LinkedHashSet<Object> allChildren = new LinkedHashSet<Object>();
        Object[] objectArray = children = adapterFactoryContentProvider.getChildren(parent);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            Object manipulatedSelection = this.manipulateSelection(object);
            if (EObject.class.isInstance(manipulatedSelection)) {
                allChildren.add(manipulatedSelection);
                allChildren.addAll(this.getAllChildren(object, adapterFactoryContentProvider));
            }
            ++n2;
        }
        return allChildren;
    }

    private Object manipulateSelection(Object object) {
        return TreeMasterDetailSelectionManipulatorHelper.manipulateSelection((Object)object);
    }

    public void dispose() {
        this.adapterFactoryContentProvider.dispose();
        this.adapterFactory.dispose();
    }

    public int getPriority() {
        return 2;
    }

    public void childViewModelContextAdded(ViewModelContext childContext) {
        this.checkForTreeMasterDetail(childContext);
    }

    private static class TreeContextMapping {
        private VTreeMasterDetail control;
        private ViewModelContext context;

        private TreeContextMapping() {
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
            result = 31 * result + (this.control == null ? 0 : this.control.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TreeContextMapping other = (TreeContextMapping)obj;
            if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
                return false;
            }
            return !(this.control == null ? other.control != null : !this.control.equals(other.control));
        }
    }

    private final class TreeMasterDetailValidationInitiatorDomainChangeListener
    implements ModelChangeListener {
        private final ViewModelContext context;

        private TreeMasterDetailValidationInitiatorDomainChangeListener(ViewModelContext context) {
            this.context = context;
        }

        public void notifyChange(ModelChangeNotification notification) {
            if (notification.getRawNotification().isTouch() || TreeMasterDetailValidationInitiator.this.mapping.isEmpty()) {
                return;
            }
            for (TreeContextMapping treeContextEntry : new LinkedHashSet(TreeMasterDetailValidationInitiator.this.mapping.keySet())) {
                if (!((Set)TreeMasterDetailValidationInitiator.this.mapping.get(treeContextEntry)).contains(TreeMasterDetailValidationInitiator.this.manipulateSelection(notification.getNotifier()))) {
                    return;
                }
                Set children = TreeMasterDetailValidationInitiator.this.getAllChildren(notification.getNotifier(), TreeMasterDetailValidationInitiator.this.adapterFactoryContentProvider);
                if (((Set)TreeMasterDetailValidationInitiator.this.mapping.get(treeContextEntry)).containsAll(children)) {
                    return;
                }
                children.removeAll((Collection)TreeMasterDetailValidationInitiator.this.mapping.get(treeContextEntry));
                for (Object child : children) {
                    EObject addedObject = (EObject)TreeMasterDetailValidationInitiator.this.manipulateSelection(child);
                    ((Set)TreeMasterDetailValidationInitiator.this.mapping.get(treeContextEntry)).add(addedObject);
                    VElement viewModel = this.context.getViewModel();
                    VViewModelProperties properties = ViewModelPropertiesHelper.getInhertitedPropertiesOrEmpty((VElement)viewModel);
                    properties.addNonInheritableProperty(TreeMasterDetailValidationInitiator.DETAIL_KEY, (Object)true);
                    ViewModelContext childContext = treeContextEntry.context.getChildContext(addedObject, (VElement)treeContextEntry.control, ViewProviderHelper.getView((EObject)addedObject, (VViewModelProperties)properties), new ViewModelService[0]);
                    childContext.addContextUser((Object)this);
                }
            }
        }
    }
}

