/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecp.core.ECPProvider;
import org.eclipse.emf.ecp.core.ECPRepository;
import org.eclipse.emf.ecp.core.ECPRepositoryManager;
import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.core.util.ECPRepositoryAware;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.core.util.observer.ECPObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPPropertiesObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPProvidersChangedObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPRepositoriesChangedObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPRepositoryContentChangedObserver;
import org.eclipse.emf.ecp.internal.core.Activator;
import org.eclipse.emf.ecp.internal.core.ECPRepositoryImpl;
import org.eclipse.emf.ecp.internal.core.util.ExtensionParser;
import org.eclipse.emf.ecp.internal.core.util.InternalUtil;
import org.eclipse.emf.ecp.internal.core.util.Properties;
import org.eclipse.emf.ecp.internal.core.util.PropertiesStore;
import org.eclipse.emf.ecp.spi.core.InternalProvider;
import org.eclipse.emf.ecp.spi.core.InternalRepository;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.io.IOUtil;

public final class ECPRepositoryManagerImpl
extends PropertiesStore<InternalRepository, ECPObserver>
implements ECPRepositoryManager,
ECPProvidersChangedObserver {
    private static final String DYNAMIC_PROPERTIES_EXTENSION = ".dynamic_properties";
    private final RepositoryParser extensionParser = new RepositoryParser();

    public ECPRepositoryManagerImpl() {
        File stateLocation = Activator.getInstance().getStateLocation().toFile();
        this.setFolder(new File(stateLocation, "repositories"));
    }

    @Override
    public InternalRepository getRepository(Object adaptable) {
        if (adaptable instanceof ECPRepositoryAware) {
            ECPRepositoryAware repositoryAware = (ECPRepositoryAware)adaptable;
            return (InternalRepository)repositoryAware.getRepository();
        }
        return (InternalRepository)AdapterUtil.adapt((Object)adaptable, InternalRepository.class);
    }

    @Override
    public InternalRepository getRepository(String name) {
        return (InternalRepository)this.getElement(name);
    }

    @Override
    public Collection<ECPRepository> getRepositories() {
        return this.getElements();
    }

    public boolean hasRepositories() {
        return this.hasElements();
    }

    @Override
    public ECPRepository addRepository(ECPProvider provider, String name, String label, String description, ECPProperties properties) {
        if (!provider.hasCreateRepositorySupport()) {
            throw new UnsupportedOperationException("The provider " + provider.getLabel() + " doesn't support the addition of new repositories.");
        }
        ECPRepositoryImpl repository = new ECPRepositoryImpl(provider, name, properties);
        repository.setLabel(label);
        repository.setDescription(description);
        ((InternalProvider)provider).handleLifecycle(repository, InternalProvider.LifecycleEvent.CREATE);
        this.changeElements(null, Collections.singleton(repository));
        return repository;
    }

    public void notifyObjectsChanged(ECPRepository repository, Collection<Object> objects) {
        try {
            ECPUtil.getECPObserverBus().notify(ECPRepositoryContentChangedObserver.class).contentChanged(repository, objects);
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
    }

    @Override
    public void providersChanged(Collection<ECPProvider> oldProviders, Collection<ECPProvider> newProviders) {
        Set<ECPProvider> addedProviders = InternalUtil.getAddedElements(oldProviders, newProviders);
        if (!addedProviders.isEmpty()) {
            this.load();
        }
    }

    @Override
    protected File getFile(InternalRepository element) {
        if (element instanceof RepositoryDescriptor) {
            return new File(this.getFolder(), String.valueOf(element.getName()) + DYNAMIC_PROPERTIES_EXTENSION);
        }
        return super.getFile(element);
    }

    @Override
    protected boolean isLoadableElement(File file) {
        return super.isLoadableElement(file) && !file.getName().endsWith(DYNAMIC_PROPERTIES_EXTENSION);
    }

    @Override
    protected InternalRepository loadElement(ObjectInput in) throws IOException {
        return new ECPRepositoryImpl(in);
    }

    @Override
    protected void notifyObservers(Collection<InternalRepository> oldRepositories, Collection<InternalRepository> newRepositories) throws Exception {
        ECPUtil.getECPObserverBus().notify(ECPRepositoriesChangedObserver.class).repositoriesChanged(oldRepositories, newRepositories);
    }

    @Override
    protected void doActivate() throws Exception {
        super.doActivate();
        this.extensionParser.activate();
        ECPUtil.getECPObserverBus().register(this);
    }

    protected void doDeactivate() throws Exception {
        ECPUtil.getECPObserverBus().unregister(this);
        this.extensionParser.deactivate();
        super.doDeactivate();
    }

    private final class RepositoryDescriptor
    extends ExtensionParser.ExtensionDescriptor<InternalRepository>
    implements InternalRepository {
        private final Set<String> declaredPropertyKeys;
        private final ECPProperties properties;

        public RepositoryDescriptor(String name, IConfigurationElement configurationElement) {
            block8: {
                super(ECPRepositoryManagerImpl.this, name, "Repository", configurationElement);
                this.properties = new Properties(){

                    @Override
                    public void addProperty(String key, String value) {
                        this.excludeDeclaredProperties(key);
                        super.addProperty(key, value);
                    }

                    @Override
                    public void removeProperty(String key) {
                        this.excludeDeclaredProperties(key);
                        super.removeProperty(key);
                    }

                    private void excludeDeclaredProperties(String key) {
                        if (RepositoryDescriptor.this.declaredPropertyKeys != null && RepositoryDescriptor.this.declaredPropertyKeys.contains(key)) {
                            throw new IllegalArgumentException("Statically declared property can not be changed: " + key);
                        }
                    }

                    @Override
                    protected Collection<Map.Entry<String, String>> getElementsToWrite() {
                        ArrayList<Map.Entry<String, String>> elementsToWrite = new ArrayList<Map.Entry<String, String>>();
                        for (Map.Entry entry : this.getElements()) {
                            if (RepositoryDescriptor.this.declaredPropertyKeys.contains(entry.getKey())) continue;
                            elementsToWrite.add(entry);
                        }
                        return elementsToWrite;
                    }
                };
                IConfigurationElement[] iConfigurationElementArray = configurationElement.getChildren("property");
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement property = iConfigurationElementArray[n2];
                    String key = property.getAttribute("key");
                    String value = property.getAttribute("value");
                    this.properties.addProperty(key, value);
                    ++n2;
                }
                this.declaredPropertyKeys = new HashSet<String>(this.properties.getKeys());
                FileInputStream stream = null;
                try {
                    try {
                        File file = ECPRepositoryManagerImpl.this.getFile(this);
                        if (file.exists()) {
                            stream = new FileInputStream(file);
                            ObjectInputStream in = new ObjectInputStream(stream);
                            Properties dynamicProperties = new Properties(in);
                            for (Map.Entry<String, String> property : dynamicProperties.getProperties()) {
                                this.properties.addProperty(property.getKey(), property.getValue());
                            }
                        }
                    }
                    catch (IOException ex) {
                        Activator.log(ex);
                        IOUtil.close(stream);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(stream);
                    throw throwable;
                }
                IOUtil.close(stream);
            }
            this.properties.addObserver(new ECPPropertiesObserver(){

                @Override
                public void propertiesChanged(ECPProperties properties, Collection<Map.Entry<String, String>> oldProperties, Collection<Map.Entry<String, String>> newProperties) {
                    ((ECPRepositoryManagerImpl)ECPUtil.getECPRepositoryManager()).storeElement(RepositoryDescriptor.this);
                }
            });
        }

        @Override
        public boolean isStorable() {
            return true;
        }

        @Override
        public void write(ObjectOutput out) throws IOException {
            ((Properties)this.properties).write(out);
        }

        @Override
        public InternalProvider getProvider() {
            String providerName = this.getConfigurationElement().getAttribute("provider");
            return (InternalProvider)ECPUtil.getECPProviderRegistry().getProvider(providerName);
        }

        @Override
        public ECPProperties getProperties() {
            return this.properties;
        }

        @Override
        public Object getProviderSpecificData() {
            return ((InternalRepository)this.getResolvedElement()).getProviderSpecificData();
        }

        @Override
        public void setProviderSpecificData(Object data) {
            ((InternalRepository)this.getResolvedElement()).setProviderSpecificData(data);
        }

        @Override
        public boolean canDelete() {
            return false;
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void notifyObjectsChanged(Collection<Object> objects) {
            ((InternalRepository)this.getResolvedElement()).notifyObjectsChanged(objects);
        }

        @Override
        protected InternalRepository resolve() throws Exception {
            return new ECPRepositoryImpl(this.getProvider(), this.getName(), this.getProperties());
        }
    }

    private final class RepositoryParser
    extends ExtensionParser<InternalRepository> {
        private static final String EXTENSION_POINT_NAME = "repositories";

        public RepositoryParser() {
            super(ECPRepositoryManagerImpl.this, "org.eclipse.emf.ecp.core", EXTENSION_POINT_NAME);
        }

        @Override
        protected InternalRepository createElement(String name, IConfigurationElement configurationElement) {
            RepositoryDescriptor descriptor = new RepositoryDescriptor(name, configurationElement);
            descriptor.setLabel(configurationElement.getDeclaringExtension().getLabel());
            descriptor.setDescription(configurationElement.getAttribute("description"));
            return descriptor;
        }
    }
}

