/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.group.swt.internal.collapsable;

import javax.inject.Inject;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.ContainerSWTRenderer;
import org.eclipse.emf.ecp.view.spi.group.model.VGroup;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsRendererFactory;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Layout;

public class CollapsableGroupSWTRenderer
extends ContainerSWTRenderer<VGroup> {
    private static final int MARGIN = 5;
    private SWTGridDescription rendererGridDescription;

    @Inject
    public CollapsableGroupSWTRenderer(VGroup vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsRendererFactory factory, EMFFormsDatabinding emfFormsDatabinding) {
        super((VElement)vElement, viewContext, reportService, factory, emfFormsDatabinding);
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
            SWTGridCell swtGridCell = (SWTGridCell)this.rendererGridDescription.getGrid().get(0);
            swtGridCell.setVerticalFill(false);
            swtGridCell.setVerticalGrab(false);
        }
        return this.rendererGridDescription;
    }

    protected Control renderControl(SWTGridCell gridCell, final Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        final ExpandBar bar = new ExpandBar(parent, 0);
        bar.setBackground(parent.getBackground());
        final Composite composite = new Composite((Composite)bar, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 5;
        fillLayout.marginWidth = 5;
        composite.setLayout((Layout)fillLayout);
        final ExpandItem item0 = new ExpandItem(bar, 0, 0);
        String text = ((VGroup)this.getVElement()).getName();
        if (text == null) {
            text = "";
        }
        item0.setText(text);
        super.renderControl(gridCell, composite);
        int height = this.computeHeight(composite);
        item0.setHeight(height);
        item0.setControl((Control)composite);
        bar.addExpandListener(new ExpandListener(){

            public void itemCollapsed(ExpandEvent e) {
                item0.setHeight(item0.getHeaderHeight());
                Object layoutData = bar.getLayoutData();
                this.updateLayoutData(layoutData, item0.getHeaderHeight() + 10);
                parent.layout(true, true);
                ((VGroup)CollapsableGroupSWTRenderer.this.getVElement()).setCollapsed(true);
                CollapsableGroupSWTRenderer.this.postCollapsed();
            }

            public void itemExpanded(ExpandEvent e) {
                item0.setHeight(CollapsableGroupSWTRenderer.this.computeHeight(composite));
                Object layoutData = bar.getLayoutData();
                this.updateLayoutData(layoutData, CollapsableGroupSWTRenderer.this.computeHeight(composite) + item0.getHeaderHeight() + 10);
                parent.layout(true, true);
                ((VGroup)CollapsableGroupSWTRenderer.this.getVElement()).setCollapsed(false);
                CollapsableGroupSWTRenderer.this.postExpanded();
            }

            private void updateLayoutData(Object layoutData, int height) {
                if (layoutData instanceof GridData) {
                    GridData gridData = (GridData)layoutData;
                    gridData.heightHint = height;
                }
            }
        });
        item0.setExpanded(!((VGroup)this.getVElement()).isCollapsed());
        return bar;
    }

    protected void postExpanded() {
    }

    protected void postCollapsed() {
    }

    private int computeHeight(Composite composite) {
        return composite.computeSize((int)-1, (int)-1).y + 1;
    }
}

