/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.model;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.internal.core.util.ChildrenListImpl;
import org.eclipse.emf.ecp.internal.ui.Activator;
import org.eclipse.emf.ecp.internal.ui.Messages;
import org.eclipse.emf.ecp.internal.ui.model.StructuredContentProvider;
import org.eclipse.emf.ecp.spi.core.InternalProvider;
import org.eclipse.emf.ecp.spi.core.util.InternalChildrenList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class TreeContentProvider<INPUT>
extends StructuredContentProvider<INPUT>
implements ITreeContentProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private final Map<Object, Object> parentsCache = new WeakHashMap<Object, Object>();
    private final Map<Object, InternalChildrenList> slowLists = new HashMap<Object, InternalChildrenList>();

    public TreeViewer getViewer() {
        return (TreeViewer)super.getViewer();
    }

    public final Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasChildren(Object parent) {
        InternalChildrenList childrenList;
        if (parent instanceof SyntheticElement || ECPUtil.isDisposed((Object)parent) || ECPUtil.isClosed((Object)parent)) {
            return false;
        }
        InternalChildrenList internalChildrenList = childrenList = this.getChildrenList(parent);
        synchronized (internalChildrenList) {
            block5: {
                if (childrenList.isComplete()) break block5;
                return true;
            }
            return childrenList.hasChildren();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object[] getChildren(Object parent) {
        boolean complete;
        Object[] result;
        InternalChildrenList childrenList;
        if (parent instanceof SyntheticElement || ECPUtil.isDisposed((Object)parent) || ECPUtil.isClosed((Object)parent)) {
            return NO_CHILDREN;
        }
        InternalChildrenList internalChildrenList = childrenList = this.getChildrenList(parent);
        synchronized (internalChildrenList) {
            result = childrenList.getChildren();
            complete = childrenList.isComplete();
        }
        int i = 0;
        while (i < result.length) {
            Object child = result[i];
            this.parentsCache.put(child, parent);
            ++i;
        }
        if (!complete) {
            Object[] withPending = new Object[result.length + 1];
            System.arraycopy(result, 0, withPending, 0, result.length);
            withPending[result.length] = new SlowElement(parent);
            result = withPending;
        }
        return result;
    }

    public final Object getParent(Object child) {
        EObject childEObject;
        if (child instanceof SyntheticElement) {
            return ((SyntheticElement)child).getParent();
        }
        Object result = this.parentsCache.get(child);
        if (result == null && EObject.class.isInstance(child) && (result = (childEObject = (EObject)child).eContainer()) != null && this.parentsCache.containsKey(result)) {
            return result;
        }
        return result;
    }

    public final void refreshViewer(boolean isStructuralChange, Object ... objects) {
        if (objects.length == 0) {
            return;
        }
        TreeViewer viewer = this.getViewer();
        Control control = viewer.getControl();
        if (!control.isDisposed()) {
            Display display = control.getDisplay();
            ECPProject ecpProject = ECPUtil.getECPProjectManager().getProject(objects[0]);
            boolean isThreadSafe = true;
            if (ecpProject != null) {
                InternalProvider provider = (InternalProvider)ecpProject.getProvider();
                isThreadSafe = provider.isThreadSafe();
            }
            if (display.getSyncThread() != Thread.currentThread()) {
                Runnable refreshRunnable = this.createRefreshRunnable(isStructuralChange, viewer, objects);
                if (Boolean.getBoolean("enableDisplaySync") && !isThreadSafe) {
                    display.syncExec(refreshRunnable);
                } else {
                    display.asyncExec(refreshRunnable);
                }
            } else if (isStructuralChange) {
                TreeContentProvider.refresh(viewer, objects);
            } else {
                TreeContentProvider.update(viewer, objects);
            }
        }
    }

    private Runnable createRefreshRunnable(final boolean isStructuralChange, final TreeViewer viewer, final Object ... objects) {
        return new Runnable(){

            @Override
            public void run() {
                if (isStructuralChange) {
                    TreeContentProvider.refresh(viewer, objects);
                } else {
                    TreeContentProvider.update(viewer, objects);
                }
            }
        };
    }

    protected boolean isSlow(Object parent) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternalChildrenList getChildrenList(Object parent) {
        ChildrenListImpl childrenList;
        if (this.isSlow(parent)) {
            SlowChildrenList newList = null;
            Map<Object, InternalChildrenList> map = this.slowLists;
            synchronized (map) {
                childrenList = this.slowLists.get(parent);
                if (childrenList == null) {
                    newList = new SlowChildrenList(parent);
                    childrenList = newList;
                    this.slowLists.put(parent, (InternalChildrenList)childrenList);
                }
            }
            if (newList != null) {
                newList.startThread();
            }
        } else {
            childrenList = new ChildrenListImpl(parent);
            this.fillChildrenDetectError(parent, (InternalChildrenList)childrenList);
        }
        return childrenList;
    }

    protected void fillChildrenDetectError(Object parent, InternalChildrenList childrenList) {
        try {
            this.fillChildren(parent, childrenList);
        }
        catch (Throwable t) {
            Activator.log(t);
            ErrorElement errorElement = new ErrorElement(parent, t);
            childrenList.addChildWithoutRefresh((Object)errorElement);
        }
    }

    protected abstract void fillChildren(Object var1, InternalChildrenList var2);

    public static void refresh(TreeViewer viewer, Object ... objects) {
        if (!viewer.getControl().isDisposed()) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                viewer.refresh(object);
                ++n2;
            }
        }
    }

    public static void update(TreeViewer viewer, Object ... objects) {
        if (!viewer.getControl().isDisposed()) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object != null) {
                    viewer.update(object, null);
                }
                ++n2;
            }
        }
    }

    public static final class ErrorElement
    extends SyntheticElement {
        private final Throwable cause;

        public ErrorElement(Object parent, Throwable cause) {
            super(parent);
            this.cause = cause;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public String toString() {
            return Messages.TreeContentProvider_ErrorElement_Error;
        }
    }

    private final class SlowChildrenList
    extends ChildrenListImpl
    implements Runnable {
        private static final long serialVersionUID = 1L;
        private boolean complete;

        public SlowChildrenList(Object parent) {
            super(parent);
        }

        public void startThread() {
            Thread thread = new Thread((Runnable)this, "SlowChildrenList");
            thread.setDaemon(true);
            thread.start();
        }

        @Override
        public void run() {
            TreeContentProvider.this.fillChildrenDetectError(this.getParent(), (InternalChildrenList)this);
            this.setComplete();
        }

        public boolean isSlow() {
            return true;
        }

        public boolean isComplete() {
            return this.complete;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setComplete() {
            if (!this.complete) {
                try {
                    this.complete = true;
                    this.childrenAdded();
                }
                catch (Throwable throwable) {
                    Map map = TreeContentProvider.this.slowLists;
                    synchronized (map) {
                        TreeContentProvider.this.slowLists.remove(this.getParent());
                    }
                    throw throwable;
                }
                Map map = TreeContentProvider.this.slowLists;
                synchronized (map) {
                    TreeContentProvider.this.slowLists.remove(this.getParent());
                }
            }
        }

        protected void childrenAdded() {
            final TreeViewer viewer = TreeContentProvider.this.getViewer();
            final Control control = viewer.getControl();
            if (!control.isDisposed()) {
                Display display = control.getDisplay();
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!control.isDisposed()) {
                            TreeContentProvider.refresh(viewer, SlowChildrenList.this.getParent());
                        }
                    }
                });
            }
        }
    }

    public static final class SlowElement
    extends SyntheticElement {
        public SlowElement(Object parent) {
            super(parent);
        }

        public String toString() {
            return Messages.TreeContentProvider_SlowElement_Pending;
        }
    }

    public static class SyntheticElement {
        private final Object parent;

        public SyntheticElement(Object parent) {
            this.parent = parent;
        }

        public final Object getParent() {
            return this.parent;
        }
    }
}

