/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.connection.xmlrpc;

import org.eclipse.emf.emfstore.internal.server.EMFStore;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.AccessControl;
import org.eclipse.emf.emfstore.internal.server.connection.ConnectionHandler;
import org.eclipse.emf.emfstore.internal.server.connection.xmlrpc.XmlRpcEmfStoreImpl;
import org.eclipse.emf.emfstore.internal.server.connection.xmlrpc.XmlRpcWebserverManager;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlRpcConnectionHandler
implements ConnectionHandler<EMFStore> {
    public static final String EMFSTORE = "EmfStore";
    private static final String NAME = "XML RPC Connection Handler";
    private static EMFStore emfStore;
    private static AccessControl accessControl;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public synchronized void init(EMFStore emfStore, AccessControl accessControl) throws FatalESException {
        XmlRpcConnectionHandler.emfStore = emfStore;
        XmlRpcConnectionHandler.accessControl = accessControl;
        XmlRpcWebserverManager webServer = XmlRpcWebserverManager.getInstance();
        webServer.initServer();
        webServer.addHandler(EMFSTORE, XmlRpcEmfStoreImpl.class);
    }

    public static EMFStore getEmfStore() {
        return emfStore;
    }

    public static AccessControl getAccessControl() {
        return accessControl;
    }

    @Override
    public void stop() {
        XmlRpcWebserverManager webserverManager = XmlRpcWebserverManager.getInstance();
        if (!webserverManager.removeHandler(EMFSTORE)) {
            webserverManager.stopServer();
        }
    }
}

