/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.core;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.AuthorizationControl;
import org.eclipse.emf.emfstore.internal.server.core.AbstractSubEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.core.InternalCommand;
import org.eclipse.emf.emfstore.internal.server.core.MonitorProvider;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidInputException;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.ServerSpace;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEmfstoreInterface {
    private AuthorizationControl authorizationControl;
    private HashMap<Class<? extends AbstractSubEmfstoreInterface>, AbstractSubEmfstoreInterface> subInterfaces;
    private boolean accessControlDisabled;
    private final ServerSpace serverSpace;

    public AbstractEmfstoreInterface(ServerSpace serverSpace, AuthorizationControl authorizationControl) throws FatalESException {
        this.serverSpace = serverSpace;
        if (serverSpace == null || authorizationControl == null) {
            throw new FatalESException();
        }
        this.authorizationControl = authorizationControl;
        this.accessControlDisabled = false;
        this.subInterfaces = new LinkedHashMap<Class<? extends AbstractSubEmfstoreInterface>, AbstractSubEmfstoreInterface>();
        this.initSubInterfaces();
        for (AbstractSubEmfstoreInterface subInterface : this.subInterfaces.values()) {
            subInterface.initSubInterface();
        }
    }

    protected abstract void initSubInterfaces() throws FatalESException;

    protected void addSubInterface(AbstractSubEmfstoreInterface subInterface) {
        if (subInterface != null) {
            this.getSubInterfaces().put(subInterface.getClass(), subInterface);
        }
    }

    protected HashMap<Class<? extends AbstractSubEmfstoreInterface>, AbstractSubEmfstoreInterface> getSubInterfaces() {
        return this.subInterfaces;
    }

    protected <T> T getSubInterface(Class<T> clazz) {
        return (T)this.subInterfaces.get(clazz);
    }

    protected ServerSpace getServerSpace() {
        return this.serverSpace;
    }

    protected Object getMonitor() {
        return MonitorProvider.getInstance().getMonitor();
    }

    protected AuthorizationControl getAuthorizationControl() {
        return this.authorizationControl;
    }

    protected synchronized void checkReadAccess(SessionId sessionId, ProjectId projectId, Set<EObject> modelElements) throws AccessControlException {
        if (this.accessControlDisabled) {
            return;
        }
        this.getAuthorizationControl().checkReadAccess(sessionId, projectId, modelElements);
    }

    protected synchronized void checkWriteAccess(SessionId sessionId, ProjectId projectId, Set<EObject> modelElements) throws AccessControlException {
        if (this.accessControlDisabled) {
            return;
        }
        this.getAuthorizationControl().checkWriteAccess(sessionId, projectId, modelElements);
    }

    protected synchronized void checkProjectAdminAccess(SessionId sessionId, ProjectId projectId) throws AccessControlException {
        if (this.accessControlDisabled) {
            return;
        }
        this.getAuthorizationControl().checkProjectAdminAccess(sessionId, projectId);
    }

    protected synchronized void checkServerAdminAccess(SessionId sessionId) throws AccessControlException {
        if (this.accessControlDisabled) {
            return;
        }
        this.getAuthorizationControl().checkServerAdminAccess(sessionId);
    }

    protected void sanityCheckObjects(Object ... objects) throws InvalidInputException {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            this.sanityCheckObject(object);
            ++n2;
        }
    }

    private void sanityCheckObject(Object object) throws InvalidInputException {
        if (object == null) {
            throw new InvalidInputException();
        }
    }

    public synchronized void runCommand(InternalCommand<? extends AbstractEmfstoreInterface> command) {
        this.accessControlDisabled = true;
        command.setInterface(this);
        command.doExecute();
        this.accessControlDisabled = false;
    }
}

