/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.DecisionManager;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictOption;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.VisualConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util.DecisionUtil;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucket;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiReferenceOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiReferenceSetOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiReferenceSetConflict
extends VisualConflict {
    private final boolean containmentConflict = ((MultiReferenceOperation)this.getLeftOperation()).isAdd() && !this.getLeftOperation().getModelElementId().equals(this.getRightOperation().getModelElementId());

    public MultiReferenceSetConflict(ConflictBucket conf, DecisionManager decisionManager, boolean myMultiRef) {
        super(conf, decisionManager, myMultiRef, false);
        this.init();
    }

    @Override
    protected ConflictDescription initConflictDescription(ConflictDescription description) {
        if (this.containmentConflict) {
            description.setDescription(DecisionUtil.getDescription("multireferencesetconflict.containment", this.getDecisionManager().isBranchMerge()));
        } else if (this.isLeftMy()) {
            description.setDescription(DecisionUtil.getDescription("multireferencesetconflict.my", this.getDecisionManager().isBranchMerge()));
        } else {
            description.setDescription(DecisionUtil.getDescription("multireferencesetconflict.their", this.getDecisionManager().isBranchMerge()));
        }
        description.add("target", this.isLeftMy() ? (ModelElementId)this.getMyOperation(MultiReferenceOperation.class).getReferencedModelElements().get(0) : this.getMyOperation(MultiReferenceSetOperation.class).getNewValue());
        description.add("othercontainer", this.getLeftOperation().getModelElementId());
        description.setImage("multiref.gif");
        return description;
    }

    @Override
    protected void initConflictOptions(List<ConflictOption> options) {
        ConflictOption myOption = new ConflictOption("", ConflictOption.OptionType.MyOperation);
        myOption.addOperations(this.getMyOperations());
        ConflictOption theirOption = new ConflictOption("", ConflictOption.OptionType.TheirOperation);
        theirOption.addOperations(this.getTheirOperations());
        if (this.containmentConflict) {
            EObject target = this.getDecisionManager().getModelElement((ModelElementId)((MultiReferenceOperation)this.getLeftOperation()).getReferencedModelElements().get(0));
            myOption.setOptionLabel("Move " + DecisionUtil.getClassAndName(target) + "to" + DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getMyOperation().getModelElementId())));
            theirOption.setOptionLabel("Move " + DecisionUtil.getClassAndName(target) + " to" + DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getTheirOperation().getModelElementId())));
        } else if (this.isLeftMy()) {
            EObject target = this.getDecisionManager().getModelElement((ModelElementId)this.getMyOperation(MultiReferenceOperation.class).getReferencedModelElements().get(0));
            myOption.setOptionLabel("Remove " + DecisionUtil.getClassAndName(target));
            theirOption.setOptionLabel("Set " + DecisionUtil.getClassAndName(target));
        } else {
            EObject target = this.getDecisionManager().getModelElement((ModelElementId)this.getTheirOperation(MultiReferenceOperation.class).getReferencedModelElements().get(0));
            myOption.setOptionLabel("Set " + DecisionUtil.getClassAndName(target));
            theirOption.setOptionLabel("Remove " + DecisionUtil.getClassAndName(target));
        }
        options.add(myOption);
        options.add(theirOption);
    }
}

