/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.DecisionManager;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictOption;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.VisualConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util.DecisionUtil;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucket;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiReferenceSetOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiReferenceSetSetConflict
extends VisualConflict {
    private boolean containmentConflict = this.getMyOperation().getModelElementId().equals(this.getTheirOperation().getModelElementId());

    public MultiReferenceSetSetConflict(ConflictBucket conflictBucket, DecisionManager decisionManager) {
        super(conflictBucket, decisionManager, true, false);
        this.init();
    }

    @Override
    protected ConflictDescription initConflictDescription(ConflictDescription description) {
        if (!this.containmentConflict) {
            description.setDescription(DecisionUtil.getDescription("multireferencesetsetconflict.set", this.getDecisionManager().isBranchMerge()));
        } else {
            description.setDescription(DecisionUtil.getDescription("multireferencesetsetconflict.move", this.getDecisionManager().isBranchMerge()));
        }
        description.add("value", this.getMyOperation(MultiReferenceSetOperation.class).getNewValue());
        description.add("ovalue", this.getTheirOperation(MultiReferenceSetOperation.class).getNewValue());
        description.add("othercontainer", this.getTheirOperation().getModelElementId());
        description.setImage("multiref.gif");
        return description;
    }

    @Override
    protected void initConflictOptions(List<ConflictOption> options) {
        ConflictOption myOption = new ConflictOption("", ConflictOption.OptionType.MyOperation);
        myOption.addOperations(this.getMyOperations());
        ConflictOption theirOption = new ConflictOption("", ConflictOption.OptionType.TheirOperation);
        theirOption.addOperations(this.getTheirOperations());
        if (!this.containmentConflict) {
            myOption.setOptionLabel(DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getMyOperation(MultiReferenceSetOperation.class).getNewValue())));
            theirOption.setOptionLabel(DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getTheirOperation(MultiReferenceSetOperation.class).getNewValue())));
        } else {
            EObject target = this.getDecisionManager().getModelElement(this.getMyOperation(MultiReferenceSetOperation.class).getNewValue());
            myOption.setOptionLabel("Move " + DecisionUtil.getClassAndName(target) + "to" + DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getMyOperation().getModelElementId())));
            theirOption.setOptionLabel("Move " + DecisionUtil.getClassAndName(target) + " to" + DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getTheirOperation().getModelElementId())));
        }
        options.add(myOption);
        options.add(theirOption);
    }
}

