/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.controller;

import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.LoginCanceledException;
import org.eclipse.emf.emfstore.internal.client.ui.common.RunInUI;
import org.eclipse.emf.emfstore.internal.client.ui.controller.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIShareProjectController
extends AbstractEMFStoreUIController<Void> {
    private final ESLocalProject localProject;
    private ESUsersession usersession;

    public UIShareProjectController(Shell shell, ESLocalProject localProject) {
        super(shell, true, false);
        this.localProject = localProject;
    }

    public UIShareProjectController(Shell shell, ESUsersession usersession, ESLocalProject localProject) {
        super(shell, true, true);
        this.usersession = usersession;
        this.localProject = localProject;
    }

    @Override
    public Void doRun(IProgressMonitor progressMonitor) throws ESException {
        try {
            this.localProject.shareProject(this.usersession != null ? this.usersession : null, progressMonitor);
            RunInUI.run(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    MessageDialog.openInformation((Shell)UIShareProjectController.this.getShell(), (String)"Share succeeded", (String)"The project has been successfully shared.");
                    return null;
                }
            });
        }
        catch (LoginCanceledException loginCanceledException) {
        }
        catch (ESException e) {
            RunInUI.run(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    MessageDialog.openError((Shell)UIShareProjectController.this.getShell(), (String)"Share project failed", (String)e.getMessage());
                    return null;
                }
            });
        }
        return null;
    }
}

