/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers;

import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.common.APIUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers.PasswordVerifier;
import org.eclipse.emf.emfstore.internal.server.core.MonitorProvider;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.model.AuthenticationInformation;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.AccesscontrolFactory;
import org.eclipse.emf.emfstore.server.model.ESAuthenticationInformation;
import org.eclipse.emf.emfstore.server.model.ESClientVersionInfo;
import org.eclipse.emf.emfstore.server.model.ESOrgUnitProvider;
import org.eclipse.emf.emfstore.server.model.ESUser;

public abstract class UserVerifier
extends PasswordVerifier {
    private final ESOrgUnitProvider orgUnitProvider;

    public UserVerifier(ESOrgUnitProvider orgUnitProvider) {
        this.orgUnitProvider = orgUnitProvider;
    }

    public ESAuthenticationInformation verifyUser(String username, String password, ESClientVersionInfo clientVersionInfo) throws AccessControlException {
        this.checkClientVersion(clientVersionInfo);
        String preparedPassword = this.preparePassword(password);
        if (this.verifySuperUser(username, preparedPassword) || this.verifyPassword(username, preparedPassword)) {
            AuthenticationInformation createAuthenticationInfo = this.createAuthenticationInfo();
            createAuthenticationInfo.setResolvedACUser((ACUser)ModelUtil.clone((EObject)this.findUser(username)));
            return (ESAuthenticationInformation)createAuthenticationInfo.toAPI();
        }
        throw new AccessControlException();
    }

    protected ACUser findUser(String username) throws AccessControlException {
        Boolean ignoreCase = Boolean.parseBoolean(ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.matchusers.ignorecase", Boolean.FALSE.toString()));
        Boolean createAuthenticatedUsers = Boolean.parseBoolean(ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.createusers", Boolean.FALSE.toString()));
        Object object = MonitorProvider.getInstance().getMonitor();
        synchronized (object) {
            Set users = this.orgUnitProvider.getUsers();
            Set internal = APIUtil.toInternal((Set)users);
            for (ACUser user : internal) {
                if (ignoreCase.booleanValue()) {
                    if (!user.getName().equalsIgnoreCase(username)) continue;
                    return user;
                }
                if (!user.getName().equals(username)) continue;
                return user;
            }
            if (createAuthenticatedUsers.booleanValue()) {
                ACUser acUser = AccesscontrolFactory.eINSTANCE.createACUser();
                acUser.setName(username);
                acUser.setDescription("");
                this.orgUnitProvider.addUser((ESUser)acUser.toAPI());
                return acUser;
            }
            throw new AccessControlException();
        }
    }
}

