/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.configuration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.client.handler.ESChecksumErrorHandler;
import org.eclipse.emf.emfstore.client.provider.ESClientConfigurationProvider;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.internal.client.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESServerImpl;
import org.eclipse.emf.emfstore.internal.client.model.util.ChecksumErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Behavior {
    public static final long NO_CHECKSUM = -1L;
    private static final String RESOURCE_OPTIONS_EXTENSION_POINT_NAME = "org.eclipse.emf.emfstore.client.changeRecordingOptions";
    private static final String AUTO_SAVE_EXTENSION_POINT_ATTRIBUTE_NAME = "autoSave";
    private static final String RERECORD_LOCAL_CHANGES_EXTENSION_POINT_ATTRIBUTE_NAME = "rerecordLocalChanges";
    private static final String CUT_OFF_INCOMING_CROSS_REFS_EXTENSION_POINT_ATTRIBUTE_NAME = "cutOffIncomingCrossReferences";
    private static final String FORCE_COMMANDS_EXTENSION_POINT_ATTRIBUTE_NAME = "forceCommands";
    private static final String DENY_ADD_CUT_ELEMENTS_TO_MODELELEMENTS_FEATURE_EXTENSION_POINT_ATTRIBUTE_NAME = "denyAddCutElementsToModelElements";
    private static Boolean isAutoSaveActive;
    private static Boolean isRerecordingActive;
    private static Boolean isCutOffIncomingCrossReferencesActive;
    private static Boolean isForceCommandsActive;
    private static Boolean isDenyAddCutElementsToModelElementsFeatureActive;
    private ESChecksumErrorHandler checksumErrorHandler;

    public void setAutoSave(boolean enabled) {
        isAutoSaveActive = new Boolean(enabled);
    }

    public boolean isAutoSaveEnabled() {
        if (isAutoSaveActive == null) {
            isAutoSaveActive = new ESExtensionPoint(RESOURCE_OPTIONS_EXTENSION_POINT_NAME).getBoolean(AUTO_SAVE_EXTENSION_POINT_ATTRIBUTE_NAME, false);
        }
        return isAutoSaveActive;
    }

    public Boolean isRerecordingActivated() {
        if (isRerecordingActive == null) {
            isRerecordingActive = new ESExtensionPoint(RESOURCE_OPTIONS_EXTENSION_POINT_NAME).getBoolean(RERECORD_LOCAL_CHANGES_EXTENSION_POINT_ATTRIBUTE_NAME, Boolean.TRUE.booleanValue());
        }
        return isRerecordingActive;
    }

    public Boolean isCutOffIncomingCrossReferencesActivated() {
        if (isCutOffIncomingCrossReferencesActive == null) {
            isCutOffIncomingCrossReferencesActive = new ESExtensionPoint(RESOURCE_OPTIONS_EXTENSION_POINT_NAME).getBoolean(CUT_OFF_INCOMING_CROSS_REFS_EXTENSION_POINT_ATTRIBUTE_NAME, Boolean.TRUE.booleanValue());
        }
        return isCutOffIncomingCrossReferencesActive;
    }

    public Boolean isForceCommandsActived() {
        if (isForceCommandsActive == null) {
            isForceCommandsActive = new ESExtensionPoint(RESOURCE_OPTIONS_EXTENSION_POINT_NAME).getBoolean(FORCE_COMMANDS_EXTENSION_POINT_ATTRIBUTE_NAME, Boolean.FALSE.booleanValue());
        }
        return isForceCommandsActive;
    }

    public Boolean isDenyAddCutElementsToModelElementsFeatureActived() {
        if (isDenyAddCutElementsToModelElementsFeatureActive == null) {
            isDenyAddCutElementsToModelElementsFeatureActive = new ESExtensionPoint(RESOURCE_OPTIONS_EXTENSION_POINT_NAME).getBoolean(DENY_ADD_CUT_ELEMENTS_TO_MODELELEMENTS_FEATURE_EXTENSION_POINT_ATTRIBUTE_NAME, Boolean.FALSE.booleanValue());
        }
        return isDenyAddCutElementsToModelElementsFeatureActive;
    }

    public boolean isChecksumCheckActive() {
        ESExtensionPoint extensionPoint = new ESExtensionPoint("org.eclipse.emf.emfstore.client.checksumErrorHandler");
        return extensionPoint.getBoolean("isActive", true);
    }

    public ESChecksumErrorHandler getChecksumErrorHandler() {
        if (this.checksumErrorHandler == null) {
            ESChecksumErrorHandler errorHandler;
            ESExtensionPoint extensionPoint = new ESExtensionPoint("org.eclipse.emf.emfstore.client.checksumErrorHandler");
            ESExtensionElement elementWithHighestPriority = extensionPoint.getElementWithHighestPriority();
            if (elementWithHighestPriority != null && (errorHandler = (ESChecksumErrorHandler)elementWithHighestPriority.getClass("errorHandler", ESChecksumErrorHandler.class)) != null) {
                this.checksumErrorHandler = errorHandler;
            }
            if (this.checksumErrorHandler == null) {
                this.checksumErrorHandler = ChecksumErrorHandler.CANCEL;
            }
        }
        return this.checksumErrorHandler;
    }

    public void setChecksumErrorHandler(ESChecksumErrorHandler errorHandler) {
        this.checksumErrorHandler = errorHandler;
    }

    public List<ServerInfo> getDefaultServerInfos() {
        ESClientConfigurationProvider provider = (ESClientConfigurationProvider)new ESExtensionPoint("org.eclipse.emf.emfstore.client.defaultConfigurationProvider").getClass("providerClass", ESClientConfigurationProvider.class);
        ArrayList<ServerInfo> result = new ArrayList<ServerInfo>();
        if (provider != null) {
            List<ESServer> defaultServerInfos = provider.getDefaultServerInfos();
            for (ESServer server : defaultServerInfos) {
                result.add((ServerInfo)((ESServerImpl)server).toInternalAPI());
            }
            return result;
        }
        result.add(this.getLocalhostServerInfo());
        return result;
    }

    private ServerInfo getLocalhostServerInfo() {
        ServerInfo serverInfo = ModelFactory.eINSTANCE.createServerInfo();
        serverInfo.setName("Localhost Server");
        serverInfo.setPort(8080);
        serverInfo.setUrl("localhost");
        serverInfo.setCertificateAlias("emfstore test certificate (do not use in production!)");
        Usersession superUsersession = ModelFactory.eINSTANCE.createUsersession();
        superUsersession.setServerInfo(serverInfo);
        superUsersession.setPassword("super");
        superUsersession.setSavePassword(true);
        superUsersession.setUsername("super");
        serverInfo.setLastUsersession(superUsersession);
        return serverInfo;
    }
}

