/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.fuzzy.emf;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.dom4j.DocumentException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.emfstore.fuzzy.emf.ESFuzzyEMFDataProvider;
import org.eclipse.emf.emfstore.fuzzy.emf.ESMutateUtil;
import org.eclipse.emf.emfstore.fuzzy.emf.ESMutatorConfig;
import org.eclipse.emf.emfstore.fuzzy.emf.ESTestConfig;
import org.eclipse.emf.emfstore.fuzzy.emf.Messages;
import org.eclipse.emf.emfstore.fuzzy.emf.internal.diff.HudsonTestRunProvider;
import org.eclipse.emf.emfstore.fuzzy.emf.junit.ESFuzzyTest;
import org.eclipse.emf.emfstore.fuzzy.emf.junit.ESFuzzyUtil;
import org.eclipse.emf.emfstore.internal.fuzzy.emf.FuzzyUtil;
import org.eclipse.emf.emfstore.internal.fuzzy.emf.api.ESTestConfigImpl;
import org.eclipse.emf.emfstore.internal.fuzzy.emf.config.ConfigFactory;
import org.eclipse.emf.emfstore.internal.fuzzy.emf.config.ConfigPackage;
import org.eclipse.emf.emfstore.internal.fuzzy.emf.config.DiffReport;
import org.eclipse.emf.emfstore.internal.fuzzy.emf.config.TestConfig;
import org.eclipse.emf.emfstore.internal.fuzzy.emf.config.TestDiff;
import org.eclipse.emf.emfstore.internal.fuzzy.emf.config.TestResult;
import org.eclipse.emf.emfstore.internal.fuzzy.emf.config.TestRun;
import org.eclipse.emf.emfstore.modelmutator.ESAbstractModelMutator;
import org.eclipse.emf.emfstore.modelmutator.ESModelMutatorConfiguration;
import org.junit.runner.notification.RunListener;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ESXMIResourceDataProvider
implements ESFuzzyEMFDataProvider {
    public static final String MODELS_FOLDER_NAME = "models";
    private Random random;
    private int count;
    private int seedCount;
    private TestClass testClass;
    private TestRun testRun;
    private ESTestConfig config;
    private boolean filterTests;
    private String configFile;
    private long nextSeed;
    private EClass rootEClass;
    private ESModelMutatorConfiguration modelMutatorConfig;
    private ResourceSet resourceSet;
    private Resource diffResource;
    private File[] listFiles;
    public static final String PROP_EMFDATAPROVIDER = ".emfdataprovider";
    public static final String PROP_CONFIGS_FILE = ".configsFile";
    public static final String MUTATOR_EXC_LOG = "mutatorExcLog";
    public static final String MUTATOR_EDITINGDOMAIN = "mutatorEditingDomain";

    @Override
    public void init() {
        this.fillProperties();
        Resource configResource = FuzzyUtil.createResource(this.configFile);
        try {
            configResource.load(null);
        }
        catch (IOException e) {
            throw new RuntimeException(MessageFormat.format(Messages.EMFDataProvider_ConfigFileLoadFailed, this.configFile), e);
        }
        this.config = FuzzyUtil.getTestConfig(configResource, this.testClass);
        this.addToConfigFile();
        this.random = new Random(this.config.getSeed());
        this.resourceSet = new ResourceSetImpl();
        File modelsDir = new File(MODELS_FOLDER_NAME);
        this.listFiles = modelsDir.listFiles();
        this.count = this.config.getCount();
        this.seedCount = 0;
        ESMutatorConfig mutatorConfig = this.config.getMutatorConfig();
        this.rootEClass = mutatorConfig.getRootEClass();
        if (this.rootEClass == null) {
            this.rootEClass = ConfigPackage.Literals.ROOT;
        }
        this.modelMutatorConfig = new ESModelMutatorConfiguration();
        this.modelMutatorConfig.setMinObjectsCount(mutatorConfig.getMinObjectsCount());
        this.modelMutatorConfig.setDoNotGenerateRoot(mutatorConfig.isDoNotGenerateRoot());
        this.modelMutatorConfig.seteClassesToIgnore(mutatorConfig.getEClassesToIgnore());
        this.modelMutatorConfig.seteStructuralFeaturesToIgnore(mutatorConfig.getEStructuralFeaturesToIgnore());
        this.modelMutatorConfig.setIgnoreAndLog(mutatorConfig.isIgnoreAndLog());
        this.modelMutatorConfig.setUseEcoreUtilDelete(mutatorConfig.isUseEcoreUtilDelete());
        this.modelMutatorConfig.setMaxDeleteCount(mutatorConfig.getMaxDeleteCount());
        this.modelMutatorConfig.setModelPackages(mutatorConfig.getEPackages());
        this.modelMutatorConfig.setMutationCount(Integer.valueOf(mutatorConfig.getMutationCount()));
        this.modelMutatorConfig.setAllowDuplicateIDs(mutatorConfig.isAllowDuplicateIDs());
        this.testRun = ConfigFactory.eINSTANCE.createTestRun();
        this.testRun.setTime(new Date());
        this.testRun.setConfig((TestConfig)((ESTestConfigImpl)ESTestConfigImpl.class.cast(this.config)).toInternalAPI());
    }

    private void addToConfigFile() {
        Resource resource = FuzzyUtil.createResource("../fuzzy/fuzzyConfig.fuzzy");
        try {
            TestConfig internalConfig;
            if (FuzzyUtil.resourceExists(resource)) {
                resource.load(null);
            }
            if (!FuzzyUtil.containsConfig(resource, internalConfig = (TestConfig)((ESTestConfigImpl)ESTestConfigImpl.class.cast(this.config)).toInternalAPI())) {
                resource.getContents().add((Object)internalConfig);
                resource.save(null);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(Messages.EMFDataProvider_ConfigFileSaveFailed, e);
        }
    }

    @Override
    public EObject get(int count) {
        int remainder = (count - 1) / this.count;
        ++this.seedCount;
        this.fitSeed(count);
        this.nextSeed = this.random.nextLong();
        File file = this.listFiles[remainder];
        Resource resource = this.resourceSet.createResource(URI.createFileURI((String)file.getAbsolutePath()));
        try {
            resource.load(null);
            EObject root = (EObject)resource.getContents().get(0);
            this.modelMutatorConfig.reset();
            this.modelMutatorConfig.setRootEObject(root);
            this.modelMutatorConfig.setSeed(Long.valueOf(this.nextSeed));
            return root;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void fitSeed(int count) {
        if (count == this.seedCount) {
            return;
        }
        if (count < this.seedCount) {
            this.random = new Random(this.config.getSeed());
            this.seedCount = 0;
        }
        while (this.seedCount < count) {
            this.random.nextLong();
            ++this.seedCount;
        }
    }

    public void finish() {
        Resource runResource = FuzzyUtil.createResource("../fuzzy/testruns/" + this.config.getId() + ".xml");
        runResource.getContents().add((Object)this.testRun);
        try {
            runResource.save(null);
        }
        catch (IOException e) {
            throw new RuntimeException(Messages.EMFDataProvider_SaveRunResultFailed, e);
        }
    }

    @Override
    public int size() {
        return this.count * this.listFiles.length;
    }

    @Override
    public void setTestClass(TestClass testClass) {
        this.testClass = testClass;
    }

    @Override
    public List<RunListener> getListener() {
        return null;
    }

    @Override
    public List<ESFuzzyTest> getTestsToRun() {
        if (!this.filterTests) {
            return null;
        }
        if (this.diffResource == null) {
            try {
                this.diffResource = HudsonTestRunProvider.getDiffResource();
                this.diffResource.load(null);
            }
            catch (IOException e) {
                throw new RuntimeException(Messages.EMFDataProvider_DiffFileLoadFailed, e);
            }
            catch (DocumentException e) {
                throw new RuntimeException(Messages.EMFDataProvider_DiffFileLoadFailed, e);
            }
        }
        EList contents = this.diffResource.getContents();
        ArrayList<ESFuzzyTest> tests = new ArrayList<ESFuzzyTest>();
        for (EObject obj : contents) {
            if (!(obj instanceof DiffReport)) continue;
            for (TestDiff diff : ((DiffReport)obj).getDiffs()) {
                if (!diff.getConfig().getId().equals(this.config.getId())) continue;
                TestResult result = FuzzyUtil.getValidTestResult(diff);
                tests.add(new ESFuzzyTest(result.getTestName(), result.getSeedCount()));
            }
        }
        return tests;
    }

    @Override
    public int getCurrentSeedCount() {
        return this.seedCount;
    }

    @Override
    public long getSeed() {
        return this.nextSeed;
    }

    @Override
    public Collection<EPackage> getEPackages() {
        return this.modelMutatorConfig.getModelPackages();
    }

    private void fillProperties() {
        String filterTests = System.getProperty("filterTests");
        this.filterTests = filterTests == null ? false : Boolean.parseBoolean(filterTests);
        this.configFile = FuzzyUtil.getProperty(".emfdataprovider.configsFile", "fuzzy/fuzzyConfig.fuzzy");
    }

    @Override
    public ESFuzzyUtil getUtil() {
        return new ESMutateUtil(this);
    }

    @Override
    public ESTestConfig getConfig() {
        return this.config;
    }

    @Override
    public void setOptions(Map<String, Object> options) {
        Object o = options.get(MUTATOR_EXC_LOG);
        if (o != null && o instanceof Set) {
            this.modelMutatorConfig.setExceptionLog((Set)o);
        }
        if ((o = options.get(MUTATOR_EDITINGDOMAIN)) != null && o instanceof EditingDomain) {
            this.modelMutatorConfig.setEditingDomain((EditingDomain)o);
        }
    }

    @Override
    public ESModelMutatorConfiguration getModelMutatorConfiguration() {
        return this.modelMutatorConfig;
    }

    @Override
    public void setMutator(ESAbstractModelMutator modelMutator) {
    }
}

