/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.DecisionManager;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictOption;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.VisualConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.Messages;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util.DecisionUtil;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucket;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiReferenceSetOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiReferenceSetSetConflict
extends VisualConflict {
    private static final String MULTIREF_GIF = "multiref.gif";
    private static final String OTHERCONTAINER_KEY = "othercontainer";
    private static final String OVALUE_KEY = "ovalue";
    private static final String VALUE_KEY = "value";
    private static final String MULTIREFERENCE_SET_SET_CONFLICT_SET_KEY = "multireferencesetsetconflict.set";
    private static final String MULTIREFERENCE_SET_SET_CONFLICT_MOVE_KEY = "multireferencesetsetconflict.move";
    private final boolean containmentConflict = this.getMyOperation().getModelElementId().equals(this.getTheirOperation().getModelElementId());

    public MultiReferenceSetSetConflict(ConflictBucket conflictBucket, DecisionManager decisionManager) {
        super(conflictBucket, decisionManager, true, false);
        this.init();
    }

    @Override
    protected ConflictDescription initConflictDescription(ConflictDescription description) {
        if (!this.containmentConflict) {
            description.setDescription(DecisionUtil.getDescription(MULTIREFERENCE_SET_SET_CONFLICT_SET_KEY, this.getDecisionManager().isBranchMerge()));
        } else {
            description.setDescription(DecisionUtil.getDescription(MULTIREFERENCE_SET_SET_CONFLICT_MOVE_KEY, this.getDecisionManager().isBranchMerge()));
        }
        description.add(VALUE_KEY, this.getMyOperation(MultiReferenceSetOperation.class).getNewValue());
        description.add(OVALUE_KEY, this.getTheirOperation(MultiReferenceSetOperation.class).getNewValue());
        description.add(OTHERCONTAINER_KEY, this.getTheirOperation().getModelElementId());
        description.setImage(MULTIREF_GIF);
        return description;
    }

    @Override
    protected void initConflictOptions(List<ConflictOption> options) {
        ConflictOption myOption = new ConflictOption("", ConflictOption.OptionType.MyOperation);
        myOption.addOperations(this.getMyOperations());
        ConflictOption theirOption = new ConflictOption("", ConflictOption.OptionType.TheirOperation);
        theirOption.addOperations(this.getTheirOperations());
        if (!this.containmentConflict) {
            myOption.setOptionLabel(DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getMyOperation(MultiReferenceSetOperation.class).getNewValue())));
            theirOption.setOptionLabel(DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getTheirOperation(MultiReferenceSetOperation.class).getNewValue())));
        } else {
            EObject target = this.getDecisionManager().getModelElement(this.getMyOperation(MultiReferenceSetOperation.class).getNewValue());
            myOption.setOptionLabel(MessageFormat.format(Messages.MultiReference_Move_To, DecisionUtil.getClassAndName(target), DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getMyOperation().getModelElementId()))));
            theirOption.setOptionLabel(MessageFormat.format(Messages.MultiReference_Move_To, DecisionUtil.getClassAndName(target), DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getTheirOperation().getModelElementId()))));
        }
        options.add(myOption);
        options.add(theirOption);
    }
}

