/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.storage;

import java.io.File;
import java.util.HashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.storage.ServerSpaceFileURIHandler;
import org.eclipse.emf.emfstore.server.ESAbstractServerURIConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMIServerURIConverter
extends ESAbstractServerURIConverter {
    public static final String FILE_PREFIX_PROJECTFOLDER = "project-";
    private static final String FILE_PREFIX_CHANGEPACKAGE = "changepackage-";
    private static final String FILE_PREFIX_PROJECTSTATE = "projectstate-";
    private static final String FILE_PREFIX_VERSION = "version-";
    private static final String FILE_EXTENSION_MAINSTORAGE = ".uss";
    private static final String FILE_EXTENSION_PROJECTHISTORY = ".uph";
    private static final String FILE_EXTENSION_VERSION = ".upv";
    private static final String FILE_EXTENSION_PROJECTSTATE = ".ups";
    private static final String FILE_EXTENSION_CHANGEPACKAGE = ".ucp";

    public XMIServerURIConverter() {
        this.getURIHandlers().add(0, (Object)new ServerSpaceFileURIHandler(this.getExtensionsMap()));
    }

    @Override
    protected URI normalizeServerSpaceURI(String profile) {
        return URI.createFileURI((String)(String.valueOf(ServerConfiguration.getServerHome()) + "storage" + FILE_EXTENSION_MAINSTORAGE));
    }

    @Override
    protected URI normalizeProjectHistoryURI(String profile, String projectId) {
        return URI.createFileURI((String)(String.valueOf(this.getProjectFolder(projectId)) + "projectHistory" + FILE_EXTENSION_PROJECTHISTORY));
    }

    @Override
    protected URI normalizeVersionURI(String profile, String projectId, int version) {
        return URI.createFileURI((String)(String.valueOf(this.getProjectFolder(projectId)) + FILE_PREFIX_VERSION + version + FILE_EXTENSION_VERSION));
    }

    @Override
    protected URI normalizeChangePackageURI(String profile, String projectId, int version) {
        return URI.createFileURI((String)(String.valueOf(this.getProjectFolder(projectId)) + this.getChangePackageFile(version)));
    }

    @Override
    protected URI normalizeProjectStateURI(String profile, String projectId, int version) {
        return URI.createFileURI((String)(String.valueOf(this.getProjectFolder(projectId)) + this.getProjectFile(version)));
    }

    private String getProjectFolder(String projectId) {
        return String.valueOf(ServerConfiguration.getServerHome()) + FILE_PREFIX_PROJECTFOLDER + projectId + File.separatorChar;
    }

    private String getProjectFile(int versionNumber) {
        return FILE_PREFIX_PROJECTSTATE + versionNumber + FILE_EXTENSION_PROJECTSTATE;
    }

    private String getChangePackageFile(int versionNumber) {
        return FILE_PREFIX_CHANGEPACKAGE + versionNumber + FILE_EXTENSION_CHANGEPACKAGE;
    }

    private HashSet<String> getExtensionsMap() {
        HashSet<String> extensions = new HashSet<String>();
        extensions.add(FILE_EXTENSION_CHANGEPACKAGE);
        extensions.add(FILE_EXTENSION_PROJECTHISTORY);
        extensions.add(FILE_EXTENSION_PROJECTSTATE);
        extensions.add(FILE_EXTENSION_VERSION);
        return extensions;
    }
}

