/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dap.variables.maps;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.epsilon.eol.dap.variables.IVariableReference;
import org.eclipse.epsilon.eol.dap.variables.IdentifiableReference;
import org.eclipse.epsilon.eol.dap.variables.SuspendedState;
import org.eclipse.epsilon.eol.dap.variables.maps.MapEntryReference;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.types.EolMapType;

public class PerKeyMapReference
extends IdentifiableReference<Map<Object, Object>> {
    private final String name;

    public PerKeyMapReference(IEolContext context, String name, Map<Object, Object> m) {
        super(context, m);
        this.name = name;
    }

    @Override
    public String getTypeName() {
        return new EolMapType().getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<IVariableReference> getVariables(SuspendedState state) {
        ArrayList<IVariableReference> refs = new ArrayList<IVariableReference>(((Map)this.target).size());
        int i = 0;
        for (Object key : ((Map)this.target).keySet()) {
            String entryName = String.format("%s[%d]", this.name, i++);
            refs.add(state.putOrGetReference(new MapEntryReference(this.context, entryName, (Map)this.target, key)));
        }
        return refs;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.name);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PerKeyMapReference other = (PerKeyMapReference)obj;
        return Objects.equals(this.name, other.name);
    }
}

