/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.datatypes.xsd.impl;

import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.xsd.XSDDuration;
import org.apache.jena.datatypes.xsd.impl.XSDAbstractDateTimeType;

public class XSDDurationType
extends XSDAbstractDateTimeType {
    public XSDDurationType() {
        super("duration");
        this.javaClass = XSDDuration.class;
    }

    @Override
    public Object parseValidated(String str2) {
        int end;
        int endDate;
        char c;
        int len = str2.length();
        int[] date2 = new int[9];
        int start = 0;
        if ((c = str2.charAt(start++)) != 'P' && c != '-') {
            throw new DatatypeFormatException("Internal error: validated duration failed to parse(1)");
        }
        int n = date2[7] = c == '-' ? 45 : 0;
        if (c == '-' && str2.charAt(start++) != 'P') {
            throw new DatatypeFormatException("Internal error: validated duration failed to parse(2)");
        }
        int negate = 1;
        if (date2[7] == 45) {
            negate = -1;
        }
        if ((endDate = this.indexOf(str2, start, len, 'T')) == -1) {
            endDate = len;
        }
        if ((end = this.indexOf(str2, start, endDate, 'Y')) != -1) {
            date2[0] = negate * this.parseInt(str2, start, end);
            start = end + 1;
        }
        if ((end = this.indexOf(str2, start, endDate, 'M')) != -1) {
            date2[1] = negate * this.parseInt(str2, start, end);
            start = end + 1;
        }
        if ((end = this.indexOf(str2, start, endDate, 'D')) != -1) {
            date2[2] = negate * this.parseInt(str2, start, end);
            start = end + 1;
        }
        if (len == endDate && start != len) {
            throw new DatatypeFormatException("Internal error: validated duration failed to parse(3)");
        }
        if (len != endDate) {
            if ((end = this.indexOf(str2, ++start, len, 'H')) != -1) {
                date2[3] = negate * this.parseInt(str2, start, end);
                start = end + 1;
            }
            if ((end = this.indexOf(str2, start, len, 'M')) != -1) {
                date2[4] = negate * this.parseInt(str2, start, end);
                start = end + 1;
            }
            if ((end = this.indexOf(str2, start, len, 'S')) != -1) {
                int mlsec = this.indexOf(str2, start, end, '.');
                if (mlsec > 0) {
                    date2[5] = negate * this.parseInt(str2, start, mlsec);
                    int msEnd = end;
                    while (str2.charAt(msEnd - 1) == '0') {
                        --msEnd;
                    }
                    date2[6] = negate * this.parseInt(str2, mlsec + 1, msEnd);
                    date2[8] = msEnd - mlsec - 1;
                } else {
                    date2[5] = negate * this.parseInt(str2, start, end);
                }
                start = end + 1;
            }
        }
        return new XSDDuration(date2);
    }
}

