/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.rdf.emf.converter.jobs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.apache.jena.rdf.model.Model;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.epsilon.rdf.emf.RDFGraphResourceImpl;
import org.eclipse.epsilon.rdf.emf.config.RDFResourceConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PlatformUI;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;

public class XMI2RDFJob
extends Job {
    private final IFile modelFile;
    private final String targetFileExtension;

    public XMI2RDFJob(IFile modelFile, String targetFileExtension, String targetFileType) {
        super("Convert XMI to " + targetFileType);
        this.modelFile = modelFile;
        this.targetFileExtension = targetFileExtension;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IStatus run(IProgressMonitor monitor) {
        void folder;
        IContainer container;
        String rdfresFilename = this.replaceFileExtension(this.modelFile.getName(), "rdfres");
        String ttlFilename = this.replaceFileExtension(this.modelFile.getName(), this.targetFileExtension);
        RDFResourceConfiguration config = new RDFResourceConfiguration();
        config.getDataModels().add(ttlFilename);
        IContainer iContainer = container = this.modelFile.getParent();
        if (!(iContainer instanceof IFolder)) return Status.error((String)"Container is not a folder");
        IFolder iFolder = (IFolder)iContainer;
        IFolder cfr_ignored_0 = (IFolder)iContainer;
        IFile rdfresFile = folder.getFile(rdfresFilename);
        try {
            this.saveConfiguration(monitor, config, rdfresFile);
        }
        catch (Exception ex) {
            return Status.error((String)"Failed to save .rdfres", (Throwable)ex);
        }
        IFile ttlFile = folder.getFile(ttlFilename);
        try {
            if (ttlFile.exists()) {
                ttlFile.delete(true, monitor);
            }
            ttlFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, monitor);
        }
        catch (Exception ex) {
            return Status.error((String)"Failed to generate empty .ttl", (Throwable)ex);
        }
        ResourceSetImpl sourceRS = new ResourceSetImpl();
        Resource sourceR = sourceRS.getResource(URI.createURI((String)this.modelFile.getLocationURI().toString()), true);
        ResourceSetImpl targetRS = new ResourceSetImpl();
        RDFGraphResourceImpl targetR = (RDFGraphResourceImpl)targetRS.getResource(URI.createURI((String)rdfresFile.getLocationURI().toString()), true);
        targetR.getContents().clear();
        Model jenaModel = targetR.getFirstNamedModel();
        jenaModel.setNsPrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        jenaModel.setNsPrefix("owl", "http://www.w3.org/2002/07/owl#");
        jenaModel.setNsPrefix("f", String.valueOf(targetR.getURI()) + "#");
        if (!sourceR.getContents().isEmpty()) {
            EObject root = (EObject)sourceR.getContents().get(0);
            EPackage ePkg = root.eClass().getEPackage();
            Object nsURIPrefix = ePkg.getNsURI();
            if (!((String)nsURIPrefix).endsWith("#") && !((String)nsURIPrefix).endsWith("/")) {
                nsURIPrefix = (String)nsURIPrefix + "#";
            }
            jenaModel.setNsPrefix("mm", (String)nsURIPrefix);
        }
        targetR.getContents().addAll((Collection)sourceR.getContents());
        try {
            targetR.save(null);
            return Status.OK_STATUS;
        }
        catch (IOException e) {
            return Status.error((String)"Failed to save target .rdfres", (Throwable)e);
        }
    }

    protected void saveConfiguration(IProgressMonitor monitor, RDFResourceConfiguration config, IFile rdfresFile) throws IOException, CoreException {
        CustomClassLoaderConstructor constructor = new CustomClassLoaderConstructor(((Object)((Object)this)).getClass().getClassLoader(), new LoaderOptions());
        String dumpedYaml = new Yaml((BaseConstructor)constructor).dumpAsMap((Object)config);
        Throwable throwable = null;
        Object var7_8 = null;
        try (ByteArrayInputStream bis = new ByteArrayInputStream(dumpedYaml.getBytes(StandardCharsets.UTF_8));){
            if (rdfresFile.exists()) {
                PlatformUI.getWorkbench().getDisplay().syncCall(() -> {
                    if (MessageDialog.openConfirm(null, (String)"Overwrite?", (String)(rdfresFile.getName() + " already exists: overwrite?"))) {
                        rdfresFile.delete(true, monitor);
                    }
                    return null;
                });
            }
            rdfresFile.create((InputStream)bis, true, monitor);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected String replaceFileExtension(String originalFilename, String newExtension) {
        int dotIndex = originalFilename.lastIndexOf(46);
        if (dotIndex != -1) {
            return originalFilename.substring(0, dotIndex) + "." + newExtension;
        }
        return originalFilename + "." + newExtension;
    }
}

