/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.services;

import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.CompoundDirectedGraphLayout;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.lite.requests.SetAllBendpointsRequest;
import org.eclipse.gmf.runtime.lite.services.IDiagramLayouter;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class DefaultDiagramLayouter
implements IDiagramLayouter {
    @Override
    public Command layout(GraphicalEditPart container) {
        CompoundDirectedGraph graph = new CompoundDirectedGraph();
        HashMap<EditPart, Node> views2Nodes = this.buildGraph(container, graph);
        CompoundDirectedGraphLayout layout = new CompoundDirectedGraphLayout();
        layout.visit((DirectedGraph)graph);
        return this.createLayoutCommand(container, views2Nodes, graph);
    }

    @Override
    public Command layout(GraphicalEditPart container, List<GraphicalEditPart> selectedElements) {
        return this.layout(container);
    }

    protected HashMap<EditPart, Node> buildGraph(GraphicalEditPart container, CompoundDirectedGraph graph) {
        HashMap<EditPart, Node> views2Nodes = new HashMap<EditPart, Node>();
        this.traverseChildren(container, new SubGraphBuilder(null, graph, views2Nodes));
        Diagram diagram = ((View)container.getModel()).getDiagram();
        for (org.eclipse.gmf.runtime.notation.Edge nextEdge : diagram.getEdges()) {
            Edge edge;
            ConnectionEditPart nextEdgeEP = (ConnectionEditPart)container.getViewer().getEditPartRegistry().get(nextEdge);
            EditPart source = nextEdgeEP.getSource();
            EditPart target = nextEdgeEP.getTarget();
            Node sourceNode = views2Nodes.get(source);
            Node targetNode = views2Nodes.get(target);
            if (sourceNode == null || targetNode == null || (edge = this.createEdge(nextEdgeEP, sourceNode, targetNode)) == null) continue;
            graph.edges.add((Object)edge);
        }
        return views2Nodes;
    }

    protected void traverseChildren(GraphicalEditPart container, Traverser traverser) {
        View view = (View)container.getModel();
        for (View nextChild : view.getChildren()) {
            GraphicalEditPart nextChildEP = (GraphicalEditPart)container.getViewer().getEditPartRegistry().get(nextChild);
            if (nextChildEP == null) continue;
            traverser.acceptChild(nextChildEP);
        }
        traverser.childrenTraversed(container);
    }

    protected Edge createEdge(ConnectionEditPart next, Node sourceNode, Node targetNode) {
        return new Edge((Object)next, sourceNode, targetNode);
    }

    protected Node createNode(Subgraph parent, GraphicalEditPart next) {
        boolean hasChildren = this.hasChildren(next);
        if (!hasChildren) {
            if (this.isValidElementForLayout(next)) {
                return new Node((Object)next, parent);
            }
            return null;
        }
        return new Subgraph((Object)next, parent);
    }

    protected boolean hasChildren(GraphicalEditPart gep) {
        for (GraphicalEditPart next : gep.getChildren()) {
            if (this.isValidElementForLayout(next)) {
                return true;
            }
            if (!this.hasChildren(next)) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidElementForLayout(GraphicalEditPart gep) {
        if (!(gep.getModel() instanceof org.eclipse.gmf.runtime.notation.Node)) {
            return false;
        }
        org.eclipse.gmf.runtime.notation.Node view = (org.eclipse.gmf.runtime.notation.Node)gep.getModel();
        if (!view.isSetElement()) {
            return false;
        }
        return view.getLayoutConstraint() instanceof Bounds;
    }

    protected void setNodePosition(Node node) {
        GraphicalEditPart editPart = (GraphicalEditPart)node.data;
        org.eclipse.gmf.runtime.notation.Node notationalNode = (org.eclipse.gmf.runtime.notation.Node)editPart.getModel();
        if (notationalNode.getLayoutConstraint() instanceof Bounds) {
            Rectangle bounds = editPart.getFigure().getBounds().getCopy();
            editPart.getFigure().translateToAbsolute((Translatable)bounds);
            node.x = bounds.x;
            node.y = bounds.y;
            node.width = bounds.width;
            node.height = bounds.height;
        }
    }

    protected Rectangle getNodePosition(Node node) {
        Rectangle rect = new Rectangle(node.x, node.y, node.width, node.height);
        return rect;
    }

    protected Command createLayoutCommand(final GraphicalEditPart container, final HashMap<EditPart, Node> views2Nodes, final CompoundDirectedGraph graph) {
        return new AbstractCommand(){
            private CompoundCommand layoutCommand;

            public void redo() {
                this.layoutCommand.execute();
            }

            public void execute() {
                this.layoutCommand = new CompoundCommand();
                DefaultDiagramLayouter.this.traverseChildren(container, new ChildrenLayouter(views2Nodes, this.layoutCommand));
                DefaultDiagramLayouter.this.createLayoutEdgesCommand(graph.edges, this.layoutCommand);
            }

            protected boolean prepare() {
                return true;
            }

            public boolean canUndo() {
                return this.layoutCommand.canUndo();
            }

            public void undo() {
                this.layoutCommand.undo();
            }
        };
    }

    protected void createLayoutEdgesCommand(EdgeList edges, CompoundCommand command) {
        for (Edge next : edges) {
            if (!(next.data instanceof ConnectionEditPart)) continue;
            ConnectionEditPart connection = (ConnectionEditPart)next.data;
            PointList points = this.getPoints(next);
            SetAllBendpointsRequest request = new SetAllBendpointsRequest();
            request.setConnectionEditPart(connection);
            request.setPoints(points);
            org.eclipse.gef.commands.Command cmd = connection.getCommand((Request)request);
            if (cmd == null || !cmd.canExecute()) continue;
            cmd.execute();
            command.add(cmd);
        }
    }

    private PointList getPoints(Edge edge) {
        PointList result = new PointList();
        result.addPoint(((GraphicalEditPart)((ConnectionEditPart)edge.data).getSource()).getFigure().getBounds().getCenter());
        NodeList vnodes = edge.vNodes;
        if (vnodes != null) {
            int i = 0;
            while (i < vnodes.size()) {
                Node vn = vnodes.getNode(i);
                Rectangle nextPosition = this.getNodePosition(vn);
                result.addPoint(nextPosition.getCenter());
                ++i;
            }
        }
        result.addPoint(((GraphicalEditPart)((ConnectionEditPart)edge.data).getTarget()).getFigure().getBounds().getCenter());
        this.straightenPoints(result);
        result.removePoint(0);
        result.removePoint(result.size() - 1);
        return result;
    }

    private void straightenPoints(PointList points) {
        double flatnessTolerance = Math.cos(Math.PI / 360);
        this.removeFlatAngles(points, flatnessTolerance);
    }

    /*
     * Unable to fully structure code
     */
    private void removeFlatAngles(PointList points, double flatnessTolerance) {
        i = 0;
        ** GOTO lbl8
        {
            points.removePoint(i + 1);
            do {
                if (i < points.size() - 2 && points.size() > 3 && this.cos(points.getPoint(i), points.getPoint(i + 1), points.getPoint(i + 2)) > flatnessTolerance) continue block0;
                ++i;
lbl8:
                // 2 sources

            } while (i < points.size() - 2 && points.size() > 3);
        }
    }

    private double cos(Point a, Point b, Point c) {
        double ab2 = b.getDistance2(a);
        double ac2 = c.getDistance2(a);
        double bc2 = b.getDistance2(c);
        return (ab2 + ac2 - bc2) / (2.0 * Math.sqrt(ab2 * ac2));
    }

    protected class ChildrenLayouter
    implements Traverser {
        private final CompoundCommand myCommand;
        private final HashMap<EditPart, Node> myViews2Nodes;

        public ChildrenLayouter(HashMap<EditPart, Node> views2Nodes, CompoundCommand command) {
            this.myViews2Nodes = views2Nodes;
            this.myCommand = command;
        }

        @Override
        public void acceptChild(GraphicalEditPart childEditPart) {
            Node node = this.myViews2Nodes.get(childEditPart);
            if (node == null) {
                return;
            }
            ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
            Rectangle bounds = DefaultDiagramLayouter.this.getNodePosition(node);
            Point ptLocation = new Point(bounds.x, bounds.y);
            Rectangle oldBounds = childEditPart.getFigure().getBounds();
            childEditPart.getFigure().translateToAbsolute((Translatable)oldBounds);
            Point oldLocation = oldBounds.getLocation();
            Dimension delta = ptLocation.getDifference(oldLocation);
            request.setEditParts((EditPart)childEditPart);
            request.setMoveDelta(new Point(delta.width, delta.height));
            request.setSizeDelta(bounds.getSize().getDifference(oldBounds.getSize()));
            request.setLocation(ptLocation);
            org.eclipse.gef.commands.Command cmd = childEditPart.getCommand((Request)request);
            if (cmd != null && cmd.canExecute()) {
                cmd.execute();
                this.myCommand.add(cmd);
            }
        }

        @Override
        public void childrenTraversed(GraphicalEditPart parentEditPart) {
            parentEditPart.getFigure().invalidateTree();
            parentEditPart.getFigure().validate();
            DefaultDiagramLayouter.this.traverseChildren(parentEditPart, new Traverser(){

                @Override
                public void acceptChild(GraphicalEditPart childEditPart) {
                    DefaultDiagramLayouter.this.traverseChildren(childEditPart, ChildrenLayouter.this);
                }

                @Override
                public void childrenTraversed(GraphicalEditPart parentEditPart) {
                }
            });
        }
    }

    protected class SubGraphBuilder
    implements Traverser {
        private final Subgraph myParent;
        private final CompoundDirectedGraph myGraph;
        private final HashMap<EditPart, Node> myViews2Nodes;

        public SubGraphBuilder(Subgraph parent, CompoundDirectedGraph graph, HashMap<EditPart, Node> views2Nodes) {
            this.myParent = parent;
            this.myGraph = graph;
            this.myViews2Nodes = views2Nodes;
        }

        @Override
        public void acceptChild(GraphicalEditPart childEditPart) {
            Node node = DefaultDiagramLayouter.this.createNode(this.myParent, childEditPart);
            if (node != null) {
                DefaultDiagramLayouter.this.setNodePosition(node);
                this.myGraph.nodes.add((Object)node);
                this.myViews2Nodes.put((EditPart)childEditPart, node);
                if (node instanceof Subgraph) {
                    DefaultDiagramLayouter.this.traverseChildren(childEditPart, new SubGraphBuilder((Subgraph)node, this.myGraph, this.myViews2Nodes));
                }
            }
        }

        @Override
        public void childrenTraversed(GraphicalEditPart parentEditPart) {
        }
    }

    protected static interface Traverser {
        public void acceptChild(GraphicalEditPart var1);

        public void childrenTraversed(GraphicalEditPart var1);
    }
}

