/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.internal.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;

public class Generate {
    protected PrintWriter printWriter = null;
    protected StringWriter stringWriter = new StringWriter();

    public StringWriter createStringWriter() {
        return new StringWriter(40960);
    }

    protected File getDestdir() {
        return new File("");
    }

    public PrintWriter getPrintWriter() {
        if (this.printWriter == null) {
            this.stringWriter = this.createStringWriter();
            this.printWriter = new PrintWriter(this.stringWriter);
        }
        return this.printWriter;
    }

    public StringWriter getStringWriter() {
        return this.stringWriter;
    }

    public boolean isSave() {
        return true;
    }

    private void logError(String string) {
        System.out.println(string);
    }

    private void logException(Exception exception) {
        exception.printStackTrace();
    }

    private void logVerbose(String string) {
        System.out.println(string);
    }

    public void print(char character) {
        this.getPrintWriter().print(character);
    }

    public void print(byte[] bytes) {
        this.getPrintWriter().print(new String(bytes));
    }

    public void print(String string) {
        this.getPrintWriter().print(string);
    }

    public void printXmlHeader() {
        this.printXmlHeader(this.getPrintWriter());
    }

    public void printXmlHeader(PrintWriter printWriter) {
        try {
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void println() {
        this.getPrintWriter().println();
    }

    public void println(char character) {
        this.getPrintWriter().println(character);
    }

    public void println(String string) {
        this.getPrintWriter().println(string);
    }

    public byte[] readData(InputStream fin) throws Exception {
        int size = fin.available();
        byte[] data = new byte[size];
        int index = 0;
        int sizeLeft = size;
        while (sizeLeft != 0) {
            index += fin.read(data, index, sizeLeft);
            sizeLeft = size - index;
        }
        fin.close();
        return data;
    }

    public void save(File file, byte[] data) {
        if (this.isSave()) {
            try {
                FileOutputStream os = new FileOutputStream(file);
                os.write(data);
                os.flush();
                os.close();
                this.logVerbose("Saving: " + file.toString());
            }
            catch (Exception exception) {
                this.logException(exception);
            }
        }
    }

    public void save(File srcDir, String filename, byte[] data) {
        if (this.isSave()) {
            try {
                FileOutputStream os = new FileOutputStream(new File(srcDir, filename));
                os.write(data);
                os.flush();
                os.close();
                this.logVerbose("Saving: " + filename);
            }
            catch (Exception exception) {
                this.logException(exception);
            }
        }
    }

    public void save(String filename, byte[] data) {
        this.save(this.getDestdir(), filename, data);
    }

    public void save(String name, String data) {
        if (this.isSave()) {
            try {
                if (data.length() > 0) {
                    File directory = this.getDestdir();
                    if (!directory.isDirectory()) {
                        this.logError("destdir not a directory " + directory);
                        return;
                    }
                    File file = new File(directory, name);
                    if (file.isDirectory()) {
                        this.logError("Can not save to directoy " + name);
                        return;
                    }
                    if (file.exists()) {
                        byte[] oldData = this.readData(new FileInputStream(file));
                        String oldString = new String(oldData);
                        if (data.equals(oldString)) {
                            this.logVerbose("Same: " + name + " in " + directory);
                            this.stringWriter = null;
                            this.printWriter = null;
                            return;
                        }
                        try {
                            file.delete();
                            file = new File(directory, name);
                        }
                        catch (Exception exception) {}
                        this.logVerbose("Replacing: " + name + " in " + directory);
                    } else {
                        this.logVerbose("Saving: " + name + " in " + directory);
                    }
                    FileOutputStream outputStream = new FileOutputStream(file);
                    ((OutputStream)outputStream).write(data.getBytes());
                    outputStream.flush();
                    ((OutputStream)outputStream).close();
                }
                this.stringWriter = null;
                this.printWriter = null;
            }
            catch (Exception exception) {
                this.logException(exception);
            }
        }
    }

    public void save(String name, StringWriter writer) {
        if (this.isSave()) {
            try {
                String data = writer.getBuffer().toString();
                this.save(name, data);
                writer.close();
            }
            catch (Exception exception) {
                this.logException(exception);
            }
        }
    }

    public void saveAllDirectory(String name) {
        if (this.isSave()) {
            try {
                File directory = this.getDestdir();
                StringTokenizer tokenizer = new StringTokenizer(name, "/");
                int count = tokenizer.countTokens();
                int i = 0;
                while (i < count - 1) {
                    String token = tokenizer.nextToken();
                    File file = new File(directory, token);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    directory = file;
                    ++i;
                }
            }
            catch (Exception exception) {
                this.logException(exception);
            }
        }
    }

    public void saveBuffer(String name, String data) {
        block10: {
            if (this.isSave()) {
                try {
                    if (data.length() <= 0) break block10;
                    File directory = this.getDestdir();
                    if (!directory.isDirectory()) {
                        this.logError("destdir not a directory " + directory);
                        return;
                    }
                    File file = new File(directory, name);
                    if (file.isDirectory()) {
                        this.logError("Can not save to directoy " + name);
                        return;
                    }
                    if (file.exists()) {
                        byte[] oldData = this.readData(new FileInputStream(file));
                        String oldString = new String(oldData);
                        if (data.equals(oldString)) {
                            this.logVerbose("Same: " + name + " in " + directory);
                            return;
                        }
                        try {
                            file.delete();
                            file = new File(directory, name);
                        }
                        catch (Exception exception) {}
                        this.logVerbose("Replacing: " + name + " in " + directory);
                    } else {
                        this.saveAllDirectory(name);
                        this.logVerbose("Saving: " + name + " in " + directory);
                    }
                    FileOutputStream outputStream = new FileOutputStream(file);
                    ((OutputStream)outputStream).write(data.getBytes());
                    outputStream.flush();
                    ((OutputStream)outputStream).close();
                }
                catch (Exception exception) {
                    this.logException(exception);
                }
            }
        }
    }

    public void saveDirectory(String name) {
        String tname = name;
        if (this.isSave()) {
            try {
                File file;
                File directory = this.getDestdir();
                if (directory == null) {
                    tname = "doc/xml/" + name;
                }
                if ((file = new File(directory, tname)).exists()) {
                    return;
                }
                file.mkdirs();
            }
            catch (Exception exception) {
                this.logException(exception);
            }
        }
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    public void setStringWriter(StringWriter stringWriter) {
        this.stringWriter = stringWriter;
    }
}

