/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.soda.devicekit.generator.build.BuildSaver;
import org.eclipse.soda.devicekit.generator.manifest.SourceFolderManifestSaver;
import org.eclipse.soda.devicekit.generator.metadata.model.CustomInfo;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.metadata.processing.CustomElementLoader;
import org.eclipse.soda.devicekit.generator.metadata.processing.MetaDataSaver;
import org.eclipse.soda.devicekit.generator.model.AbstractDkGenerator;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkAdapterBundleGenerator;
import org.eclipse.soda.devicekit.generator.model.DkAdapterGenerator;
import org.eclipse.soda.devicekit.generator.model.DkAdapterTestGenerator;
import org.eclipse.soda.devicekit.generator.model.DkAgentBundleGenerator;
import org.eclipse.soda.devicekit.generator.model.DkAgentGenerator;
import org.eclipse.soda.devicekit.generator.model.DkAgentTestGenerator;
import org.eclipse.soda.devicekit.generator.model.DkConcreteBundleGenerator;
import org.eclipse.soda.devicekit.generator.model.DkConcreteGenerator;
import org.eclipse.soda.devicekit.generator.model.DkConcreteTestGenerator;
import org.eclipse.soda.devicekit.generator.model.DkConnectionBundleGenerator;
import org.eclipse.soda.devicekit.generator.model.DkConnectionGenerator;
import org.eclipse.soda.devicekit.generator.model.DkConnectionTestGenerator;
import org.eclipse.soda.devicekit.generator.model.DkDeviceBundleGenerator;
import org.eclipse.soda.devicekit.generator.model.DkDeviceGenerator;
import org.eclipse.soda.devicekit.generator.model.DkDeviceSwtGenerator;
import org.eclipse.soda.devicekit.generator.model.DkDeviceTestCaseGenerator;
import org.eclipse.soda.devicekit.generator.model.DkDeviceTestGenerator;
import org.eclipse.soda.devicekit.generator.model.DkGenericAdapterBundleGenerator;
import org.eclipse.soda.devicekit.generator.model.DkGenericAdapterGenerator;
import org.eclipse.soda.devicekit.generator.model.DkGenericAdapterTestGenerator;
import org.eclipse.soda.devicekit.generator.model.DkProfileBundleGenerator;
import org.eclipse.soda.devicekit.generator.model.DkProfileGenerator;
import org.eclipse.soda.devicekit.generator.model.DkProfileTestAgentGenerator;
import org.eclipse.soda.devicekit.generator.model.DkProfileTestGenerator;
import org.eclipse.soda.devicekit.generator.model.DkReceiverGenerator;
import org.eclipse.soda.devicekit.generator.model.DkReceiverTestGenerator;
import org.eclipse.soda.devicekit.generator.model.DkTestAgentBundleGenerator;
import org.eclipse.soda.devicekit.generator.model.DkTestAgentGenerator;
import org.eclipse.soda.devicekit.generator.model.DkTestBundleGenerator;
import org.eclipse.soda.devicekit.generator.model.DkTestCaseGenerator;
import org.eclipse.soda.devicekit.generator.model.DkTestGenerator;
import org.eclipse.soda.devicekit.generator.model.DkTransportBundleGenerator;
import org.eclipse.soda.devicekit.generator.model.DkTransportGenerator;
import org.eclipse.soda.devicekit.generator.model.DkTransportTestCaseGenerator;
import org.eclipse.soda.devicekit.generator.model.DkTransportTestGenerator;
import org.eclipse.soda.devicekit.generator.model.EscPropertiesModel;
import org.eclipse.soda.devicekit.generator.model.elements.AdapterElement;
import org.eclipse.soda.devicekit.generator.model.elements.AgentElement;
import org.eclipse.soda.devicekit.generator.model.elements.ConnectionElement;
import org.eclipse.soda.devicekit.generator.model.elements.GenericAdapterElement;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.ProfileElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TestAgentElement;
import org.eclipse.soda.devicekit.generator.model.elements.TestElement;
import org.eclipse.soda.devicekit.generator.save.java.eclipse.DeviceKitJavaSaver;
import org.eclipse.soda.devicekit.generator.sim.DKDeviceJunitTestGenerator;
import org.eclipse.soda.devicekit.generator.sim.DkDeviceMonitorTestGenerator;
import org.eclipse.soda.devicekit.generator.sim.DkDevicePlayBackTestGenerator;
import org.eclipse.soda.devicekit.generator.sim.DkTransportJunitTestGenerator;
import org.eclipse.soda.devicekit.generator.sim.DkTransportMonitorTestGenerator;
import org.eclipse.soda.devicekit.generator.sim.DkTransportPlayBackTestGenerator;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.util.PreGenElementHolder;
import org.w3c.dom.Node;

public class DeviceKitGenerator {
    private static ResourceBundle DefaultResourceBundle;
    private String schema = null;
    private IJavaProject javaProject;
    private boolean genTestScript = false;
    private Map properties;
    private DeviceKitTagModel fDkFileModel;
    private IFile dkmlFile;
    private IFile metaDataFile;
    private boolean keepCustom;
    private List fReferences;
    private List fGeneratedFiles;
    private PreGenElementHolder customHolder;
    protected boolean genManifest;
    private GeneratedInfo generatedInfo;
    private CustomInfo customInfo;
    private CustomInfo existInfo;
    private boolean useMetaData = true;
    private IProgressMonitor progressMonitor;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.devicekit.generator.model.DeviceKitGenerator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DefaultResourceBundle = ResourceBundle.getBundle(String.valueOf(clazz.getName()) + "ResourceBundle");
    }

    public static String getResource(String key) {
        return DefaultResourceBundle.getString(key);
    }

    public DeviceKitGenerator(IFile file) {
        this((IProgressMonitor)new NullProgressMonitor(), file, new ArrayList(), false, false);
    }

    public DeviceKitGenerator(IProgressMonitor progressMonitor, IFile file, List references, boolean custom, boolean genManifest) {
        this.setProgressMonitor(progressMonitor);
        this.dkmlFile = file;
        this.fReferences = references;
        this.fGeneratedFiles = new ArrayList();
        this.keepCustom = custom;
        this.genManifest = genManifest;
    }

    protected boolean doKeepCustom() {
        return this.keepCustom;
    }

    public void generate(IProgressMonitor progressMonitor) throws Exception {
        if (progressMonitor != null) {
            this.setProgressMonitor(progressMonitor);
        }
        this.initialize();
        List types = this.fDkFileModel.getRoot().getRootTypes();
        int i = 0;
        while (i < types.size()) {
            SubProgressMonitor subMonitor = new SubProgressMonitor(progressMonitor, 90);
            this.setProgressMonitor((IProgressMonitor)subMonitor);
            TagElement element = (TagElement)types.get(i);
            String name = element.getProjectId();
            subMonitor.beginTask(name, 90);
            List result = this.generate(element, (IProgressMonitor)subMonitor);
            if (result != null && result.size() > 0) {
                this.fGeneratedFiles = DeviceKitUtilities.mergeLists(result, this.fGeneratedFiles);
            }
            this.generateEscProperties((IProgressMonitor)subMonitor);
            subMonitor.worked(5);
            if (this.useMetaData) {
                this.generateMetaData((IProgressMonitor)subMonitor);
            }
            subMonitor.worked(5);
            subMonitor.done();
            ++i;
        }
    }

    protected List generate(TagElement element, IProgressMonitor progressMonitor) throws Exception {
        switch (element.getTagCode()) {
            case 18: {
                return this.generateConcrete(element, progressMonitor);
            }
            case 8: {
                return this.generateDevice(element, progressMonitor);
            }
            case 10: {
                return this.generateTest(element, progressMonitor);
            }
            case 87: {
                return this.generateTestAgent(element, progressMonitor);
            }
            case 9: {
                return this.generateTransport(element, progressMonitor);
            }
            case 97: {
                return this.generateTransport(element, progressMonitor);
            }
            case 36: {
                return this.generateConnection(element, progressMonitor);
            }
            case 91: {
                return this.generateAgent(element, progressMonitor);
            }
            case 72: {
                return this.generateAdapter(element, progressMonitor);
            }
            case 160: {
                return this.generateGenericAdapter(element, progressMonitor);
            }
            case 74: {
                return this.generateProfile(element, progressMonitor);
            }
        }
        return new ArrayList();
    }

    protected List generateAdapter(TagElement element, IProgressMonitor progressMonitor) throws Exception {
        List subResult;
        String tagName = element.getProjectId();
        progressMonitor.subTask(tagName);
        AdapterElement deviceElement = (AdapterElement)element;
        DkAdapterGenerator gen = new DkAdapterGenerator(this.fDkFileModel, this.generatedInfo);
        gen.setGenerateManifest(this.genManifest);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        progressMonitor.worked(50);
        gen.setSaver(new DeviceKitJavaSaver(this.getFile().getProject().getName(), progressMonitor));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setBuildSaver(new BuildSaver(jProject));
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), this.genManifest, gen.getOtherManifestFiles()));
        List result = gen.save(progressMonitor);
        progressMonitor.worked(20);
        if (deviceElement.isBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".bundle");
            subResult = this.generateAdapterBundle(1, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        if (deviceElement.isDsBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".dsbundle");
            subResult = this.generateAdapterBundle(4, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        if (deviceElement.isManagedBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".managed");
            subResult = this.generateAdapterBundle(2, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        if (deviceElement.isManagedFactoryBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".factory");
            subResult = this.generateAdapterBundle(3, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        return result;
    }

    protected List generateAdapterBundle(int type, IProgressMonitor progressMonitor) throws Exception {
        DkAdapterBundleGenerator gen = new DkAdapterBundleGenerator(this.fDkFileModel, this.generatedInfo, this.properties, type);
        gen.setGenerateManifest(true);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), progressMonitor));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), true, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(jProject));
        return gen.save(progressMonitor);
    }

    protected List generateAgent(TagElement element, IProgressMonitor progressMonitor) throws Exception {
        List subResult;
        String tagName = element.getProjectId();
        progressMonitor.subTask(tagName);
        AgentElement profileElement = (AgentElement)element;
        DkAgentGenerator gen = new DkAgentGenerator(this.fDkFileModel, this.generatedInfo);
        gen.setGenerateManifest(this.genManifest);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        progressMonitor.worked(50);
        gen.setSaver(new DeviceKitJavaSaver(this.getFile().getProject().getName(), progressMonitor));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setBuildSaver(new BuildSaver(jProject));
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), this.genManifest, gen.getOtherManifestFiles()));
        List result = gen.save(progressMonitor);
        progressMonitor.worked(20);
        if (profileElement.isBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".bundle");
            subResult = this.generateAgentBundle(1, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        if (profileElement.isDsBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".dsbundle");
            subResult = this.generateAgentBundle(4, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        if (profileElement.isManagedBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".managed");
            subResult = this.generateAgentBundle(2, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        if (profileElement.isManagedFactoryBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".factory");
            subResult = this.generateAgentBundle(3, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        this.generateHtml(element, this.fDkFileModel);
        return result;
    }

    protected List generateAgentBundle(int type, IProgressMonitor progressMonitor) throws Exception {
        DkAgentBundleGenerator gen = new DkAgentBundleGenerator(this.fDkFileModel, this.generatedInfo, this.properties, type);
        gen.setGenerateManifest(true);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), progressMonitor));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), true, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(jProject));
        return gen.save(progressMonitor);
    }

    protected List generateConcrete(TagElement element, IProgressMonitor progressMonitor) throws Exception {
        List subResult;
        String tagName = element.getProjectId();
        progressMonitor.subTask(tagName);
        MainTagElement deviceElement = (MainTagElement)element;
        DkConcreteGenerator gen = new DkConcreteGenerator(this.fDkFileModel, this.generatedInfo);
        gen.setGenerateManifest(this.genManifest);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        progressMonitor.worked(50);
        gen.setSaver(new DeviceKitJavaSaver(this.getFile().getProject().getName(), progressMonitor));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), this.genManifest, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(jProject));
        List result = gen.save(progressMonitor);
        progressMonitor.worked(20);
        if (deviceElement.isBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".bundle");
            subResult = this.generateConcreteBundle(1, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        if (deviceElement.isManagedBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".managed");
            subResult = this.generateConcreteBundle(2, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        if (deviceElement.isManagedFactoryBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".factory");
            subResult = this.generateConcreteBundle(3, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        return result;
    }

    protected List generateConcreteBundle(int type, IProgressMonitor progressMonitor) throws Exception {
        DkConcreteBundleGenerator gen = new DkConcreteBundleGenerator(this.fDkFileModel, this.generatedInfo, this.properties, type);
        gen.setGenerateManifest(true);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), progressMonitor));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), true, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(this.javaProject));
        return gen.save(progressMonitor);
    }

    protected List generateConnection(TagElement element, IProgressMonitor progressMonitor) throws Exception {
        List subResult;
        String tagName = element.getProjectId();
        progressMonitor.subTask(tagName);
        ConnectionElement connectionElement = (ConnectionElement)element;
        if (this.doKeepCustom() && (this.metaDataFile == null || !this.metaDataFile.exists())) {
            this.saveCustomElements(9);
        }
        DkConnectionGenerator gen = new DkConnectionGenerator(this.fDkFileModel, this.generatedInfo, this.properties, 0);
        gen.setGenerateManifest(this.genManifest);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        progressMonitor.worked(50);
        DeviceKitJavaSaver saver = new DeviceKitJavaSaver(gen.getSourceFolderName(), progressMonitor);
        gen.setSaver(saver);
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), this.genManifest, ((AbstractDkGenerator)gen).getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(jProject));
        List result = ((AbstractDkGenerator)gen).save(progressMonitor);
        progressMonitor.worked(20);
        if (connectionElement.isBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".bundle");
            subResult = this.generateConnectionBundle(1, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        if (connectionElement.isManagedBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".managed");
            subResult = this.generateConnectionBundle(2, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        if (connectionElement.isManagedFactoryBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".factory");
            subResult = this.generateConnectionBundle(3, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        return result;
    }

    protected List generateConnectionBundle(int type, IProgressMonitor progressMonitor) throws Exception {
        DkConnectionBundleGenerator gen = new DkConnectionBundleGenerator(this.fDkFileModel, this.generatedInfo, this.properties, type);
        gen.setGenerateManifest(true);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), progressMonitor));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), true, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(jProject));
        return gen.save(progressMonitor);
    }

    protected List generateDevice(TagElement element, IProgressMonitor progressMonitor) throws Exception {
        List subResult;
        String tagName = element.getProjectId();
        progressMonitor.subTask(tagName);
        MainTagElement deviceElement = (MainTagElement)element;
        DkDeviceGenerator gen = new DkDeviceGenerator(this.fDkFileModel, this.generatedInfo);
        gen.setGenerateManifest(this.genManifest);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        progressMonitor.worked(50);
        gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), progressMonitor));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), this.genManifest, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(jProject));
        List result = ((AbstractDkGenerator)gen).save(progressMonitor);
        progressMonitor.worked(20);
        if (deviceElement.isBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".bundle");
            subResult = this.generateDeviceBundle(1, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        if (deviceElement.isManagedBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".managed");
            subResult = this.generateDeviceBundle(2, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        if (deviceElement.isManagedFactoryBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".factory");
            subResult = this.generateDeviceBundle(3, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        return result;
    }

    protected List generateDeviceBundle(int type, IProgressMonitor progressMonitor) throws Exception {
        DkDeviceBundleGenerator gen = new DkDeviceBundleGenerator(this.fDkFileModel, this.generatedInfo, this.properties, type);
        gen.setGenerateManifest(true);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        ((AbstractDkGenerator)gen).generate();
        gen.setSaver(new DeviceKitJavaSaver(((AbstractDkGenerator)gen).getSourceFolderName(), progressMonitor));
        IJavaProject jProject = this.getJavaProject(((AbstractDkGenerator)gen).getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, ((AbstractDkGenerator)gen).getSourceFolderName(), true, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(jProject));
        return ((AbstractDkGenerator)gen).save(progressMonitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void generateEscProperties(IProgressMonitor progressMonitor) throws IOException, CoreException {
        SubProgressMonitor subMonitor = progressMonitor != null ? new SubProgressMonitor(progressMonitor, 1, 4) : new NullProgressMonitor();
        try {
            ByteArrayInputStream bis;
            InputStream currentContents;
            block14: {
                IProject project = this.getFile().getProject();
                EscPropertiesModel model = EscPropertiesModel.getModel(null);
                currentContents = null;
                InputStream stream = null;
                bis = null;
                IFile escProperties = project.getFile("esc.properties");
                try {
                    subMonitor.subTask(String.valueOf(project.getName()) + "/esc.properties");
                    if (escProperties != null && escProperties.exists()) {
                        stream = escProperties.getContents(true);
                        String contents = model.getFileContents(stream, true, true);
                        bis = new ByteArrayInputStream(contents.getBytes());
                        currentContents = escProperties.getContents(true);
                        if (!DeviceKitUtilities.sameStream(currentContents, bis)) {
                            bis.reset();
                            escProperties.setContents((InputStream)bis, true, true, (IProgressMonitor)subMonitor);
                        }
                    } else {
                        String contents = model.getFileContents(null, true, true);
                        bis = new ByteArrayInputStream(contents.getBytes());
                        if (escProperties != null) {
                            escProperties.create((InputStream)bis, true, (IProgressMonitor)subMonitor);
                        }
                    }
                    Object var10_13 = null;
                    if (stream == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    if (stream != null) {
                        stream.close();
                    }
                    if (bis != null) {
                        bis.close();
                    }
                    if (currentContents == null) throw throwable;
                    currentContents.close();
                    throw throwable;
                }
                stream.close();
            }
            if (bis != null) {
                bis.close();
            }
            if (currentContents != null) {
                currentContents.close();
            }
            EscPropertiesModel.resetModel();
            Object var12_16 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            subMonitor.done();
            throw throwable;
        }
        subMonitor.done();
    }

    protected List generateGenericAdapter(TagElement element, IProgressMonitor progressMonitor) throws Exception {
        List subResult;
        String tagName = element.getProjectId();
        progressMonitor.subTask(tagName);
        GenericAdapterElement deviceElement = (GenericAdapterElement)element;
        DkGenericAdapterGenerator gen = new DkGenericAdapterGenerator(this.fDkFileModel, this.generatedInfo);
        gen.setGenerateManifest(this.genManifest);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        progressMonitor.worked(50);
        gen.setSaver(new DeviceKitJavaSaver(this.getFile().getProject().getName(), progressMonitor));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setBuildSaver(new BuildSaver(jProject));
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), this.genManifest, gen.getOtherManifestFiles()));
        List result = gen.save(progressMonitor);
        progressMonitor.worked(20);
        if (deviceElement.isBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".bundle");
            subResult = this.generateGenericAdapterBundle(1, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        if (deviceElement.isManagedBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".managed");
            subResult = this.generateGenericAdapterBundle(2, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        if (deviceElement.isManagedFactoryBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".factory");
            subResult = this.generateGenericAdapterBundle(3, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        return result;
    }

    protected List generateGenericAdapterBundle(int type, IProgressMonitor progressMonitor) throws Exception {
        DkGenericAdapterBundleGenerator gen = new DkGenericAdapterBundleGenerator(this.fDkFileModel, this.generatedInfo, this.properties, type);
        gen.setGenerateManifest(true);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), progressMonitor));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), true, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(jProject));
        return gen.save(progressMonitor);
    }

    public void generateHtml(TagElement element, DeviceKitTagModel dkFileModel) {
    }

    private List generateJunitTest(TestElement element, int testType, IProgressMonitor progressMonitor) throws Exception {
        DkTestGenerator gen = null;
        gen = testType == 8 ? new DKDeviceJunitTestGenerator(this.fDkFileModel, this.generatedInfo) : new DkTransportJunitTestGenerator(this.fDkFileModel, this.generatedInfo);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        List junits = element.getAllChildrenWithTagCode(49);
        String script = ((TagElement)junits.get(0)).getAttribute("antscript");
        this.genTestScript = script == null || script.equals("true");
        gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), progressMonitor));
        return gen.save(progressMonitor);
    }

    protected void generateMetaData(IProgressMonitor progressMonitor) throws Exception {
        MetaDataSaver saver = new MetaDataSaver(this.metaDataFile);
        saver.save(this.generatedInfo, progressMonitor);
    }

    private List generatePlayBackTest(TestElement element, int testType, IProgressMonitor progressMonitor) throws Exception {
        DkTestGenerator gen = null;
        gen = testType == 8 ? new DkDevicePlayBackTestGenerator(this.fDkFileModel, this.generatedInfo) : new DkTransportPlayBackTestGenerator(this.fDkFileModel, this.generatedInfo);
        gen.setGenerateManifest(this.genManifest);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), progressMonitor));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), this.genManifest, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(jProject));
        return gen.save(progressMonitor);
    }

    protected List generateProfile(TagElement element, IProgressMonitor progressMonitor) throws Exception {
        List subResult;
        String tagName = element.getProjectId();
        progressMonitor.subTask(tagName);
        ProfileElement profileElement = (ProfileElement)element;
        DkProfileGenerator gen = new DkProfileGenerator(this.fDkFileModel, this.generatedInfo);
        gen.setGenerateManifest(this.genManifest);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        progressMonitor.worked(50);
        gen.setSaver(new DeviceKitJavaSaver(this.getFile().getProject().getName(), progressMonitor));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setBuildSaver(new BuildSaver(jProject));
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), this.genManifest, gen.getOtherManifestFiles()));
        List result = gen.save(progressMonitor);
        progressMonitor.worked(20);
        if (profileElement.isBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".bundle");
            subResult = this.generateProfileBundle(1, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        if (profileElement.isDsBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".dsbundle");
            subResult = this.generateProfileBundle(4, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        if (profileElement.isManagedBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".managed");
            subResult = this.generateProfileBundle(2, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        if (profileElement.isManagedFactoryBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".factory");
            subResult = this.generateProfileBundle(3, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        this.generateHtml(element, this.fDkFileModel);
        progressMonitor.worked(10);
        return result;
    }

    private List generateProfileBundle(int type, IProgressMonitor progressMonitor) throws Exception {
        DkProfileBundleGenerator gen = new DkProfileBundleGenerator(this.fDkFileModel, this.generatedInfo, this.properties, type);
        gen.setGenerateManifest(true);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), progressMonitor));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), true, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(jProject));
        return gen.save(progressMonitor);
    }

    private List generateRecordTest(TestElement element, int testType, IProgressMonitor progressMonitor) throws Exception {
        DkTestGenerator gen = null;
        gen = testType == 8 ? new DkDeviceMonitorTestGenerator(this.fDkFileModel, this.generatedInfo) : new DkTransportMonitorTestGenerator(this.fDkFileModel, this.generatedInfo);
        gen.setGenerateManifest(this.genManifest);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), progressMonitor));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), this.genManifest, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(jProject));
        return gen.save(progressMonitor);
    }

    protected List generateSwt(TestElement element, int testType, IProgressMonitor progressMonitor) throws Exception {
        DkDeviceSwtGenerator gen = null;
        if (testType == 8) {
            gen = new DkDeviceSwtGenerator(this.fDkFileModel, this.generatedInfo);
        } else if (testType == 9 || testType == 97) {
            gen = new DkDeviceSwtGenerator(this.fDkFileModel, this.generatedInfo);
        }
        if (gen != null) {
            if (this.useMetaData) {
                gen.setCustomInfo(this.customInfo);
            }
            gen.generate();
            gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), progressMonitor));
            IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
            gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), this.genManifest, gen.getOtherManifestFiles()));
            gen.setBuildSaver(new BuildSaver(jProject));
            return gen.save(progressMonitor);
        }
        return new ArrayList();
    }

    protected List generateTest(TagElement element, IProgressMonitor progressMonitor) throws Exception {
        String tagName = element.getProjectId();
        progressMonitor.subTask(tagName);
        List result = null;
        DkTestGenerator gen = null;
        TestElement testElement = (TestElement)element;
        int testType = -1;
        if (testElement.getAllChildrenWithTagCode(8).size() > 0) {
            gen = new DkDeviceTestGenerator(this.fDkFileModel, this.generatedInfo);
            testType = 8;
        } else if (testElement.getAllChildrenWithTagCode(9).size() > 0) {
            gen = new DkTransportTestGenerator(this.fDkFileModel, this.generatedInfo);
            testType = 9;
        } else if (testElement.getAllChildrenWithTagCode(97).size() > 0) {
            gen = new DkReceiverTestGenerator(this.fDkFileModel, this.generatedInfo);
            testType = 97;
        } else if (testElement.getAllChildrenWithTagCode(91).size() > 0) {
            gen = new DkAgentTestGenerator(this.fDkFileModel, this.generatedInfo);
            testType = 91;
        } else if (testElement.getAllChildrenWithTagCode(36).size() > 0) {
            gen = new DkConnectionTestGenerator(this.fDkFileModel, this.generatedInfo);
            testType = 36;
        } else if (testElement.getAllChildrenWithTagCode(18).size() > 0) {
            gen = new DkConcreteTestGenerator(this.fDkFileModel, this.generatedInfo);
            testType = 18;
        } else if (testElement.getAllChildrenWithTagCode(72).size() > 0) {
            gen = new DkAdapterTestGenerator(this.fDkFileModel, this.generatedInfo);
            testType = 72;
        } else if (testElement.getAllChildrenWithTagCode(160).size() > 0) {
            gen = new DkGenericAdapterTestGenerator(this.fDkFileModel, this.generatedInfo);
            testType = 160;
        } else if (testElement.getAllChildrenWithTagCode(74).size() > 0) {
            gen = new DkProfileTestGenerator(this.fDkFileModel, this.generatedInfo);
            testType = 74;
        }
        if (gen != null) {
            List subResult;
            gen.setGenerateManifest(this.genManifest);
            if (this.useMetaData) {
                gen.setCustomInfo(this.customInfo);
            }
            gen.generate();
            gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), progressMonitor));
            IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
            gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), this.genManifest, gen.getOtherManifestFiles()));
            gen.setBuildSaver(new BuildSaver(jProject));
            result = gen.save(progressMonitor);
            if (testElement.getAllChildrenWithTagCode(48).size() > 0) {
                subResult = this.generateRecordTest(testElement, testType, progressMonitor);
                DeviceKitUtilities.mergeLists(result, subResult);
            }
            if (testElement.getAllChildrenWithTagCode(47).size() > 0) {
                subResult = this.generatePlayBackTest(testElement, testType, progressMonitor);
                DeviceKitUtilities.mergeLists(result, subResult);
            }
            if (testElement.getAllChildrenWithTagCode(49).size() > 0) {
                subResult = this.generateJunitTest(testElement, testType, progressMonitor);
                DeviceKitUtilities.mergeLists(result, subResult);
            }
            if (testElement.getAllChildrenWithTagCode(71).size() > 0) {
                subResult = this.generateTestCase(testElement, testType, progressMonitor);
                DeviceKitUtilities.mergeLists(result, subResult);
            }
            if (testElement.getAllChildrenWithTagCode(98).size() > 0) {
                subResult = this.generateSwt(testElement, testType, progressMonitor);
                DeviceKitUtilities.mergeLists(result, subResult);
            }
            if (testElement.isBundle()) {
                progressMonitor.subTask(String.valueOf(tagName) + ".bundle");
                subResult = this.generateTestBundle(testElement, testType, 1, progressMonitor);
                DeviceKitUtilities.mergeLists(result, subResult);
            }
            if (testElement.isDsBundle()) {
                progressMonitor.subTask(String.valueOf(tagName) + ".dsbundle");
                subResult = this.generateTestBundle(testElement, testType, 4, progressMonitor);
                DeviceKitUtilities.mergeLists(result, subResult);
            }
            if (testElement.isManagedBundle()) {
                progressMonitor.subTask(String.valueOf(tagName) + ".managed");
                subResult = this.generateTestBundle(testElement, testType, 2, progressMonitor);
                DeviceKitUtilities.mergeLists(result, subResult);
            }
            if (testElement.isManagedFactoryBundle()) {
                progressMonitor.subTask(String.valueOf(tagName) + ".factory");
                subResult = this.generateTestBundle(testElement, testType, 3, progressMonitor);
                DeviceKitUtilities.mergeLists(result, subResult);
            }
        }
        return result;
    }

    protected List generateTestAgent(TagElement element, IProgressMonitor progressMonitor) throws Exception {
        List subResult;
        String tagName = element.getProjectId();
        progressMonitor.subTask(tagName);
        List result = null;
        TestAgentElement testAgentElement = (TestAgentElement)element;
        DkTestAgentGenerator gen = tagName.endsWith("profile.test.agent") ? new DkProfileTestAgentGenerator(this.fDkFileModel, this.generatedInfo) : new DkTestAgentGenerator(this.fDkFileModel, this.generatedInfo);
        gen.setGenerateManifest(this.genManifest);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
            gen.setExistInfo(this.existInfo);
        }
        gen.generate();
        progressMonitor.worked(50);
        gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), progressMonitor));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), this.genManifest, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(jProject));
        result = gen.save(progressMonitor);
        progressMonitor.worked(20);
        if (testAgentElement.isBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".bundle");
            subResult = this.generateTestAgentBundle(testAgentElement, 1, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        if (testAgentElement.isDsBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".dsbundle");
            subResult = this.generateTestAgentBundle(testAgentElement, 4, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        if (testAgentElement.isManagedBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".bundle");
            subResult = this.generateTestAgentBundle(testAgentElement, 2, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        if (testAgentElement.isManagedFactoryBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".bundle");
            subResult = this.generateTestAgentBundle(testAgentElement, 3, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        return result;
    }

    private List generateTestAgentBundle(TestAgentElement testElement, int type_bundle, IProgressMonitor progressMonitor) {
        List result = new ArrayList();
        DkTestAgentBundleGenerator gen = new DkTestAgentBundleGenerator(this.fDkFileModel, this.generatedInfo, type_bundle);
        gen.setGenerateManifest(this.genManifest);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        try {
            ((AbstractDkGenerator)gen).generate();
            gen.setSaver(new DeviceKitJavaSaver(((AbstractDkGenerator)gen).getSourceFolderName(), progressMonitor));
            IJavaProject jProject = this.getJavaProject(((AbstractDkGenerator)gen).getSourceFolderName());
            gen.setManifestSaver(new SourceFolderManifestSaver(jProject, ((AbstractDkGenerator)gen).getSourceFolderName(), true, gen.getOtherManifestFiles()));
            gen.setBuildSaver(new BuildSaver(jProject));
            result = ((AbstractDkGenerator)gen).save(progressMonitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private List generateTestBundle(TestElement testElement, int testType, int type_bundle, IProgressMonitor progressMonitor) {
        List result = new ArrayList();
        AbstractDkGenerator gen = null;
        switch (testType) {
            case 8: 
            case 9: 
            case 36: 
            case 72: 
            case 74: 
            case 91: 
            case 97: {
                gen = new DkTestBundleGenerator(this.fDkFileModel, this.generatedInfo, type_bundle, testType);
            }
        }
        if (gen != null) {
            gen.setGenerateManifest(this.genManifest);
            if (this.useMetaData) {
                gen.setCustomInfo(this.customInfo);
            }
            try {
                ((DkTestBundleGenerator)gen).generate();
                gen.setSaver(new DeviceKitJavaSaver(((DkTestBundleGenerator)gen).getSourceFolderName(), progressMonitor));
                IJavaProject jProject = this.getJavaProject(((DkTestBundleGenerator)gen).getSourceFolderName());
                gen.setManifestSaver(new SourceFolderManifestSaver(jProject, ((DkTestBundleGenerator)gen).getSourceFolderName(), true, gen.getOtherManifestFiles()));
                gen.setBuildSaver(new BuildSaver(jProject));
                result = ((DkTestBundleGenerator)gen).save(progressMonitor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    protected List generateTestCase(TestElement element, int testType, IProgressMonitor progressMonitor) throws Exception {
        DkTestCaseGenerator gen = null;
        if (testType == 8) {
            gen = new DkDeviceTestCaseGenerator(this.fDkFileModel, this.generatedInfo);
        } else if (testType == 9 || testType == 97) {
            gen = new DkTransportTestCaseGenerator(this.fDkFileModel, this.generatedInfo);
        }
        if (gen != null) {
            if (this.useMetaData) {
                gen.setCustomInfo(this.customInfo);
            }
            gen.generate();
            gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), progressMonitor));
            IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
            gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), this.genManifest, gen.getOtherManifestFiles()));
            gen.setBuildSaver(new BuildSaver(jProject));
            return gen.save(progressMonitor);
        }
        return new ArrayList();
    }

    public boolean generateTestScript() {
        return this.genTestScript;
    }

    protected List generateTransport(TagElement element, IProgressMonitor progressMonitor) throws Exception {
        List subResult;
        String tagName = element.getProjectId();
        progressMonitor.subTask(tagName);
        MainTagElement transportElement = (MainTagElement)element;
        if (this.doKeepCustom() && (this.metaDataFile == null || !this.metaDataFile.exists())) {
            this.saveCustomElements(9);
        }
        DkTransportGenerator gen = element.getTagCode() == 9 ? new DkTransportGenerator(this.fDkFileModel, this.generatedInfo, this.properties) : new DkReceiverGenerator(this.fDkFileModel, this.generatedInfo, this.properties);
        gen.setGenerateManifest(this.genManifest);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        progressMonitor.worked(50);
        DeviceKitJavaSaver saver = new DeviceKitJavaSaver(gen.getSourceFolderName(), progressMonitor);
        gen.setSaver(saver);
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), this.genManifest, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(jProject));
        List result = ((AbstractDkGenerator)gen).save(progressMonitor);
        progressMonitor.worked(20);
        if (transportElement.isBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".bundle");
            subResult = this.generateTransportBundle(1, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        if (transportElement.isDsBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".dsbundle");
            subResult = this.generateTransportBundle(4, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        if (transportElement.isManagedBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".managed");
            subResult = this.generateTransportBundle(2, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        if (transportElement.isManagedFactoryBundle()) {
            progressMonitor.subTask(String.valueOf(tagName) + ".factory");
            subResult = this.generateTransportBundle(3, progressMonitor);
            DeviceKitUtilities.mergeLists(result, subResult);
        }
        progressMonitor.worked(10);
        return result;
    }

    private List generateTransportBundle(int type, IProgressMonitor progressMonitor) throws Exception {
        DkTransportBundleGenerator gen = new DkTransportBundleGenerator(this.fDkFileModel, this.generatedInfo, this.properties, type);
        gen.setGenerateManifest(true);
        if (this.useMetaData) {
            gen.setCustomInfo(this.customInfo);
        }
        gen.generate();
        gen.setSaver(new DeviceKitJavaSaver(gen.getSourceFolderName(), progressMonitor));
        IJavaProject jProject = this.getJavaProject(gen.getSourceFolderName());
        gen.setManifestSaver(new SourceFolderManifestSaver(jProject, gen.getSourceFolderName(), true, gen.getOtherManifestFiles()));
        gen.setBuildSaver(new BuildSaver(jProject));
        return gen.save(progressMonitor);
    }

    public PreGenElementHolder getCustomHolder() {
        return this.customHolder;
    }

    protected IFile getFile() {
        return this.dkmlFile;
    }

    public List getGeneratedFiles() {
        return this.fGeneratedFiles;
    }

    private IJavaProject getJavaProject(String name) throws Exception {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = ws.getRoot();
        IProject project = root.getProject(name);
        IJavaProject jProject = JavaCore.create((IProject)project);
        if (project.exists()) {
            try {
                project.refreshLocal(2, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return jProject;
    }

    public IProgressMonitor getProgressMonitor() {
        if (this.progressMonitor == null) {
            this.progressMonitor = new NullProgressMonitor();
        }
        return this.progressMonitor;
    }

    public Node getXmlDocument() {
        if (this.fDkFileModel != null) {
            return this.fDkFileModel.getXmlDocument();
        }
        return null;
    }

    private void initialize() throws Exception {
        IProject project = this.getFile().getProject();
        this.javaProject = JavaCore.create((IProject)project);
        this.fDkFileModel = new DeviceKitTagModel(this.getFile().getContents(true), this.fReferences, this.schema, false);
        this.fDkFileModel.build();
        if (this.useMetaData) {
            this.loadCustomElements();
            if (this.generatedInfo != null) {
                this.generatedInfo.prepareOldElement(this.fDkFileModel.getVersion());
            } else {
                this.generatedInfo = new GeneratedInfo();
            }
        }
    }

    protected void loadCustomElements() {
        if (this.javaProject != null && this.javaProject.exists()) {
            CustomElementLoader loader = new CustomElementLoader(this.javaProject, this.dkmlFile);
            try {
                this.customInfo = loader.loadCustomInfo();
                this.existInfo = loader.getExistInfo();
                this.generatedInfo = loader.getGeneratedInfo();
                this.metaDataFile = loader.getMetaDataFile();
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    protected void saveCustomElements(int tagCode) {
        PreGenElementHolder peh;
        if (this.javaProject != null && this.javaProject.exists() && (peh = new PreGenElementHolder(this.fDkFileModel, tagCode, this.javaProject)).exists()) {
            this.setCustomHolder(peh);
        }
    }

    protected void setCustomHolder(PreGenElementHolder peh) {
        this.customHolder = peh;
    }

    public void setMethodProperties(Map properties) {
        this.properties = properties;
    }

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public void setReferencedFiles(List references) {
        this.fReferences = references;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }
}

