/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkAgentGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.AdapterElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public class DkAgentBundleGenerator
extends DkAgentGenerator {
    public DkAgentBundleGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
    }

    public DkAgentBundleGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Map table, int bundleType) {
        super(model, generatedInfo, table, bundleType);
    }

    protected void codeBACreateService(IType ba) {
        KeyValuePair parameter;
        String[] comment;
        String returnType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_AGENT_SERVICE);
        this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_AGENT_SERVICE);
        this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        this.getManifestModel().addImportPackage(DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_AGENT_SERVICE));
        String contents = this.getBACreateServiceContents();
        if (this.targetDevice != null) {
            comment = new String[]{"Creates the profile using the specified device service.", "", "@param deviceService The device service to used when creating the adatper service.", "@return Object The profile service created by this bundle.", "@see " + this.getMainFqn()};
            parameter = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE), "deviceService");
            this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        } else {
            comment = new String[]{"Creates the agent service using the specified bundleContext.", "", "@param bundleContext The osgi bundle context to used when creating the agent service.", "@return Object The agent service created by this bundle.", "@see " + this.getMainFqn()};
            parameter = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE), "bundleContext");
            this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_BUNDLE_CONTEXT);
        }
        this.codeMethod(ba, "createService", comment, returnType, 1L, contents, new KeyValuePair[]{parameter}, null);
    }

    protected void codeBAGetAdapterServiceName(IType ba) {
        AdapterElement adapter;
        String service;
        List adapters = this.getMainElement().getAllChildrenWithTagCode(72);
        if (adapters.size() > 0 && (service = (adapter = (AdapterElement)adapters.get(0)).getServiceName()) != null) {
            if (service.indexOf(46) == -1) {
                service = String.valueOf(DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase())) + '.' + service;
            }
            String[] comment = new String[]{"Return the adapter service name used by this bundle.", "", "@return String The adapter service name.", "@see " + service};
            this.fBundleActivatorModel.addImport(service);
            String contents = this.getBAGetInterestServiceNameContents(service);
            this.codeMethod(ba, "getAdapterServiceName", comment, "String", 1L, contents);
        }
    }

    protected void codeBAGetInterestServiceName(IType ba) {
        String service;
        if (this.targetDevice != null && (service = this.targetDevice.getServiceName()) != null) {
            if (service.indexOf(46) == -1) {
                service = String.valueOf(DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase())) + '.' + service;
            }
            String[] comment = new String[]{"Return the device service name used by this bundle.", "", "@return String The interest service name.", "@see " + service};
            this.fBundleActivatorModel.addImport(service);
            String contents = this.getBAGetInterestServiceNameContents(service);
            this.codeMethod(ba, "getInterestServiceName", comment, "String", 1L, contents);
        }
        this.codeBAGetAdapterServiceName(ba);
    }

    public void generate() throws Exception {
        this.initialize();
        if (this.getManifestModel() != null) {
            this.getManifestModel().addImportPackage(this.getMainPackage());
            this.getBuildModel().addAdditionalBundles(this.getMainPackage());
        }
        if (!this.isAbstract() && this.doGenerateBundleActivator()) {
            this.generateBundleActivatorClass();
        }
        if (this.doGenerateService()) {
            this.generateManifest();
        }
        this.generateOtherFiles();
    }

    protected String getBACreateServiceContents() {
        StringBuffer buffer = new StringBuffer(32);
        String type = this.getDevice().getType();
        this.fBundleActivatorModel.addImport(type);
        buffer.append("final ");
        buffer.append(DeviceKitUtilities.stripPackage(type));
        buffer.append(" profile = new ");
        buffer.append(DeviceKitUtilities.stripPackage(type));
        buffer.append("();\n");
        if (this.targetDevice != null) {
            buffer.append("profile.setDevice(");
            buffer.append("deviceService");
            buffer.append(");\n");
        }
        buffer.append("return profile;\n");
        return buffer.toString();
    }

    protected String getManifestBundleId() {
        return this.getSourceFolderName();
    }

    protected String getManifestBundleName() {
        return this.getBundleActivatorClass();
    }

    protected List getManifestExportPackages() {
        ArrayList<String> result = new ArrayList<String>();
        String bap = this.getBundleActivatorPackage();
        result.add(bap);
        return result;
    }

    protected List getManifestExportServices() {
        List vector = super.getManifestExportServices();
        vector.add(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        List list = this.getMainElement().getAllChildrenWithTagCode(30);
        int i = 0;
        while (i < list.size()) {
            String service = ((TagElement)list.get(i)).getServiceNameFull();
            if (service != null && service.length() > 0) {
                if (service.indexOf(46) == -1) {
                    String pack = DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase());
                    service = String.valueOf(pack) + '.' + service;
                }
                vector.add(service);
            }
            ++i;
        }
        vector.add(this.getServiceFqn());
        return vector;
    }

    protected List getManifestImportPackages() {
        String serviceDevicePack;
        String corePack;
        String baseBundleActivatorPack;
        List result = super.getManifestImportPackages();
        switch (this.bundleType) {
            case 2: {
                String managedDevicePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_DEVICE_MANAGED_BA);
                if (result.contains(managedDevicePack)) break;
                result.add(managedDevicePack);
                break;
            }
            case 3: {
                String factoryDevicePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_DEVICE_MANAGED_FACTORY_BA);
                if (result.contains(factoryDevicePack)) break;
                result.add(factoryDevicePack);
            }
        }
        String connectionBundlePack = DeviceKitGenerationConstants.PACKAGE_CONNECTION_BUNDLE;
        if (!result.contains(connectionBundlePack)) {
            result.add(connectionBundlePack);
        }
        if (!result.contains(baseBundleActivatorPack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_SAT_BUNDLE_ACTIVATOR))) {
            result.add(baseBundleActivatorPack);
        }
        if (!result.contains(corePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_CORE_ESC_OBJECT))) {
            result.add(corePack);
        }
        if (!result.contains(serviceDevicePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_OSGI_DEVICE))) {
            result.add(serviceDevicePack);
        }
        List importedServices = this.getImportedServices();
        int i = 0;
        while (i < importedServices.size()) {
            String serviceFqn = (String)importedServices.get(i);
            String servicePackage = DeviceKitUtilities.extractPackage(serviceFqn);
            result.add(servicePackage);
            ++i;
        }
        return result;
    }

    protected List getManifestImportServices() {
        AdapterElement adapter;
        String service;
        List adapters;
        String service2;
        List vector = super.getManifestImportServices();
        if (this.targetDevice != null && (service2 = this.targetDevice.getServiceName()) != null) {
            if (service2.indexOf(46) == -1) {
                String pack = DeviceKitUtilities.getPackageFromClassName(service2, this.getPackageBase());
                service2 = String.valueOf(pack) + '.' + service2;
            }
            vector.add(service2);
        }
        if ((adapters = this.getMainElement().getAllChildrenWithTagCode(72)).size() > 0 && (service = (adapter = (AdapterElement)adapters.get(0)).getServiceName()) != null) {
            if (service.indexOf(46) == -1) {
                service = String.valueOf(DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase())) + '.' + service;
                vector.add(service);
            } else {
                vector.add(service);
            }
        }
        vector.add(DeviceKitGenerationConstants.CLASS_NOTIFICATION_SERVICE);
        return vector;
    }

    public List getManifestRequiredBundles() {
        List result = super.getManifestRequiredBundles();
        switch (this.bundleType) {
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                result.add("org.eclipse.equinox.metatype");
                result.add("org.eclipse.equinox.cm");
                break;
            }
            case 3: {
                result.add("org.eclipse.equinox.metatype");
                result.add("org.eclipse.equinox.cm");
            }
        }
        return result;
    }

    public String getSourceFolderName() {
        String sfName = null;
        sfName = this.getBundleActivatorPackage();
        return sfName;
    }

    public List save(IProgressMonitor progressMonitor) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.fBundleActivatorModel != null) {
            this.fBundleActivatorModel.setSaver(this.getSaver());
            this.fBundleActivatorModel.setSortOrder(3L);
            Object ba = this.fBundleActivatorModel.save(progressMonitor);
            if (ba != null) {
                result.add(ba);
            }
        }
        this.saveCommon(progressMonitor);
        return result;
    }
}

