/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.ant;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.soda.devicekit.generator.internal.model.ant.AntProperty;
import org.eclipse.soda.devicekit.generator.internal.model.ant.AntTarget;
import org.eclipse.soda.devicekit.generator.internal.model.ant.AntTask;
import org.eclipse.soda.devicekit.generator.internal.print.ant.AntFilePrinter;
import org.eclipse.soda.devicekit.generator.model.IGeneratorModel;
import org.eclipse.soda.devicekit.generator.model.ant.IAntProperty;
import org.eclipse.soda.devicekit.generator.model.ant.IAntTarget;
import org.eclipse.soda.devicekit.generator.model.ant.IAntTask;
import org.eclipse.soda.devicekit.generator.save.IFileSaver;

public class AntModel
implements IGeneratorModel {
    private String fileName;
    private String projectName;
    private String defaultTarget;
    private String baseDir;
    private List antElements;
    private IFileSaver fSaver;

    public AntModel(String fileName, String defaultTarget) {
        this(fileName, defaultTarget, null, null);
    }

    public AntModel(String fileName, String defaultTarget, String projectName, String baseDir) {
        this.fileName = fileName;
        this.projectName = projectName;
        this.defaultTarget = defaultTarget;
        this.baseDir = baseDir;
        this.setElements(new ArrayList());
    }

    public IAntProperty createAntProperty(String name, String value) {
        AntProperty property = new AntProperty(name, value);
        this.getElements().add(property);
        return property;
    }

    public IAntTarget createAntTarget(String name) {
        AntTarget target = new AntTarget(name);
        this.getElements().add(target);
        return target;
    }

    public IAntTask createAntTask(String name) {
        AntTask task = new AntTask(name);
        this.getElements().add(task);
        return task;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public String getContents() {
        AntFilePrinter printer = new AntFilePrinter(this);
        printer.print();
        return printer.getContents();
    }

    public String getDefaultTarget() {
        return this.defaultTarget;
    }

    public List getElements() {
        return this.antElements;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void print() {
        AntFilePrinter printer = new AntFilePrinter(this);
        printer.print();
    }

    public Object save() throws Exception {
        if (this.fSaver != null) {
            return this.fSaver.save(this, (IProgressMonitor)new NullProgressMonitor());
        }
        return null;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void setDefaultTarget(String defaultTarget) {
        this.defaultTarget = defaultTarget;
    }

    private void setElements(List elements) {
        this.antElements = elements;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setSaver(IFileSaver saver) {
        this.fSaver = saver;
    }
}

