/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.sim;

import java.util.List;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.elements.PlayBackElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.sim.DkDeviceSimGenerator;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public class DkDevicePlayBackTestGenerator
extends DkDeviceSimGenerator {
    public DkDevicePlayBackTestGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
    }

    protected void codeBACreateService(IType ba) {
        String[] comment = new String[]{"Creates the play back test.", "", "@return Object The play back test.", "@see " + this.getMainFqn()};
        KeyValuePair param = new KeyValuePair(DkUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE), "deviceService");
        this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        StringBuffer buffer = new StringBuffer(64);
        buffer.append(this.getMainClassName());
        buffer.append(" playBack = new ");
        buffer.append(this.getMainClassName());
        this.fBundleActivatorModel.addImport(this.getMainFqn());
        buffer.append("();\n");
        buffer.append("playBack.setDevice(deviceService);\n");
        buffer.append("return playBack;\n");
        String contents = buffer.toString();
        this.codeMethod(ba, "createService", comment, "Object", 1L, contents, new KeyValuePair[]{param}, null);
    }

    private void codeConnectionLevelField(IType test) {
        this.codeField(test, "CONNECTION_LEVEL", "short", 49L, "Field CONNECTION_LEVEL.", "0");
    }

    protected void codeConstructors(IType test) {
        super.codeConstructors(test);
        String name = this.getMainClassName();
        KeyValuePair param1 = new KeyValuePair("short", "playbackLevel");
        KeyValuePair param2 = new KeyValuePair("String", "playbackFilePath");
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("super();\n");
        buffer.append("this.playbackLevel = playbackLevel;\n");
        buffer.append("this.playbackFilePath = playbackFilePath;\n");
        buffer.append("init();\n");
        String contents = buffer.toString();
        String returnType = null;
        String comment = String.valueOf(name) + '.';
        this.codeMethod(test, name, comment, returnType, 1L, contents, new KeyValuePair[]{param1, param2}, null);
    }

    protected void codeFields(IType test) {
        super.codeFields(test);
        this.codeTransportLevelField(test);
        this.codeConnectionLevelField(test);
        this.codePlaybackConnectionField(test);
        this.codePlaybackLevelField(test);
        this.codePlaybackFilePathField(test);
    }

    protected void codeGetDefaultFilePath(IType test) {
        KeyValuePair param = new KeyValuePair("short", "level");
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("if (level == CONNECTION_LEVEL) {\n");
        buffer.append("\treturn CONNECTION_REC_FILENAME;\n");
        buffer.append("} else {\n");
        buffer.append("return TRANSPORT_REC_FILENAME;\n");
        buffer.append("}\n");
        String contents = buffer.toString();
        this.codeMethod(test, "getDefaultFilePath", "getDefaultFilePath.", "String", 17L, contents, new KeyValuePair[]{param}, null);
    }

    protected void codeGetDefaultLevel(IType test) {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("return ");
        buffer.append(this.getLevel("CONNECTION_LEVEL"));
        buffer.append(";\n");
        String contents = buffer.toString();
        this.codeMethod(test, "getDefaultLevel", "getDefaultLevel.", "short", 17L, contents);
    }

    protected void codeInit(IType test) {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_DEVICE);
        buffer.append(" device = new ");
        buffer.append(DeviceKitUtilities.stripPackage(this.getTestElement().getTargetClass()));
        this.fTestModel.addImport(this.getTestElement().getTargetClass());
        buffer.append("();\n");
        buffer.append("setDevice(device);\n");
        buffer.append("device.setup();\n");
        buffer.append("if (playbackLevel == TRANSPORT_LEVEL) {\n");
        buffer.append("\ttry {\n");
        buffer.append("\t\tdevice.setTransport(new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_PLAY_BACK_TRANSPORT));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_PLAY_BACK_TRANSPORT);
        buffer.append("(new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_XML_TRANSPORT_HANDLER));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_XML_TRANSPORT_HANDLER);
        buffer.append("(playbackFilePath), this));\n");
        buffer.append("\t} catch (");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_FILE_NOT_FOUND_EXCEPTION));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_FILE_NOT_FOUND_EXCEPTION);
        buffer.append(" e) {\n");
        buffer.append("\t\te.printStackTrace();\n");
        buffer.append("\t}\n");
        buffer.append("} else if (device.getTransport() instanceof ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_TRANSPORT_SERVICE));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_CONNECTION_TRANSPORT_SERVICE);
        buffer.append(") {\n");
        buffer.append("\ttry {\n");
        buffer.append("\t\tplaybackConnection = new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_PLAY_BACK_CONNECTION));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_PLAY_BACK_CONNECTION);
        buffer.append("(new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_XML_PLAY_BACK_CONNECTION_HANDLER));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_XML_PLAY_BACK_CONNECTION_HANDLER);
        buffer.append("(playbackFilePath), this);\n");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
        buffer.append(" currTransport = device.getTransport();\n");
        buffer.append("if (currTransport instanceof ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_TRANSPORT_SERVICE));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_CONNECTION_TRANSPORT_SERVICE);
        buffer.append(") {\n");
        buffer.append("\t\t\t((");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_TRANSPORT_SERVICE));
        buffer.append(") currTransport).setConnection(playbackConnection);\n");
        buffer.append("\t\t}\n");
        buffer.append("\t\t}catch (FileNotFoundException e) {\n");
        buffer.append("\t\t\te.printStackTrace();\n");
        buffer.append("\t\t}\n");
        buffer.append("}\n");
        String contents = buffer.toString();
        this.codeMethod(test, "init", "init.", "void", 2L, contents);
    }

    protected void codeMethods(IType test) {
        super.codeMethods(test);
        this.codePlayBackComplete(test);
        this.codeGetDefaultFilePath(test);
        this.codeGetDefaultLevel(test);
        this.codeInit(test);
        this.codeSetLevel(test);
    }

    protected void codePlayBackComplete(IType test) {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("try {\n");
        buffer.append('\t');
        buffer.append(DeviceKitUtilities.stripPackage("Thread"));
        this.fTestModel.addImport("Thread");
        buffer.append(".sleep(100);\n");
        buffer.append("} catch (InterruptedException e) {\n");
        buffer.append("\t//Ignored\n");
        buffer.append("}\n");
        buffer.append("stop();\n");
        String contents = buffer.toString();
        this.codeMethod(test, "playbackComplete", "playbackComplete.", "void", 1L, contents);
    }

    private void codePlaybackConnectionField(IType test) {
        String fieldType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_PLAY_BACK_CONNECTION);
        String value = null;
        this.codeField(test, "playbackConnection", fieldType, 2L, "Field playbackConnection.", value);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_PLAY_BACK_CONNECTION);
    }

    private void codePlaybackFilePathField(IType test) {
        String value = null;
        this.codeField(test, "playbackFilePath", "String", 2L, "Field playbackFilePath.", value);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_PLAY_BACK_CONNECTION);
    }

    private void codePlaybackLevelField(IType test) {
        String value = null;
        this.codeField(test, "playbackLevel", "short", 2L, "Field playbackLevel.", value);
    }

    protected void codeSetLevel(IType test) {
        KeyValuePair param = new KeyValuePair("short", "level");
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("this.");
        buffer.append("playbackLevel");
        buffer.append(" = level;\n");
        buffer.append("playbackFilePath = getDefaultFilePath(level);\n");
        buffer.append("init();\n");
        String contents = buffer.toString();
        this.codeMethod(test, "setLevel", "setLevel.", "void", 1L, contents, new KeyValuePair[]{param}, null);
    }

    private void codeTransportLevelField(IType test) {
        this.codeField(test, "TRANSPORT_LEVEL", "short", 49L, "Field TRANSPORT_LEVEL.", "1");
    }

    protected String getBAActivateContents() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("if (playBack != null)\n");
        buffer.append("playBack.start();\n");
        return buffer.toString();
    }

    protected String getBADeactivateContents() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("if (this.");
        buffer.append("playBack");
        buffer.append(" != null) {\n");
        buffer.append('\t');
        buffer.append("playBack");
        buffer.append(".stop();\n");
        buffer.append("}\n");
        buffer.append("playBack");
        buffer.append(" = null;\n");
        buffer.append("super.deactivate();\n");
        return buffer.toString();
    }

    protected String getBASetInterestContents() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("super.setInterest(interest);\n");
        buffer.append("if (this.");
        buffer.append("playBack");
        buffer.append(" != null) {\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    protected String getBaseName() {
        return DeviceKitUtilities.removeLastOccurence(this.getMainClassName(), "Playback");
    }

    protected String getConstructorContents() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("this(getDefaultLevel(), getDefaultFilePath(getDefaultLevel()));\n");
        return buffer.toString();
    }

    protected String[] getImplementedInterfaces() {
        return new String[]{this.getServiceFqn(), DeviceKitGenerationConstants.CLASS_PLAY_BACK_LISTENER};
    }

    protected String getLevel(String defaultLevel) {
        TagElement element;
        List pb = this.getTestElement().getAllChildrenWithTagCode(47);
        if (pb.size() > 0 && (element = (TagElement)pb.get(0)).getAttribute("level") != null) {
            String level = element.getAttribute("level");
            if (level.equals("transport")) {
                return "TRANSPORT_LEVEL";
            }
            return "CONNECTION_LEVEL";
        }
        return defaultLevel;
    }

    protected String getMainContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("try {\n");
        buffer.append('\t');
        buffer.append("final ");
        buffer.append(this.getMainClassName());
        buffer.append(' ');
        buffer.append("playBack");
        buffer.append(" = new ");
        buffer.append(this.getMainClassName());
        buffer.append("();\n");
        buffer.append('\t');
        buffer.append("playBack");
        buffer.append(".start();\n");
        buffer.append('\t');
        buffer.append("for (int i = 1; i < 100; i++){\n");
        buffer.append("\tif (");
        buffer.append("playBack");
        buffer.append(".isActive()){\n");
        buffer.append("\t\tbreak;\n");
        buffer.append("\t} else {\n");
        buffer.append("\t\t");
        buffer.append(DeviceKitUtilities.stripPackage("Thread"));
        this.fTestModel.addImport("Thread");
        buffer.append(".sleep(100);\n");
        buffer.append("\t}\n");
        buffer.append("}\n");
        buffer.append("do {\n");
        buffer.append("\t\t");
        buffer.append(DeviceKitUtilities.stripPackage("Thread"));
        this.fTestModel.addImport("Thread");
        buffer.append(".sleep(100);\n");
        buffer.append("\t} while (playBack.isActive());\n");
        buffer.append("} catch (final Exception exception) {\n");
        buffer.append("\texception.printStackTrace(System.out);\n");
        buffer.append("}\n");
        buffer.append("System.exit(0);\n");
        return buffer.toString();
    }

    protected String getManifestDescription() {
        List monitor = this.getTestElement().getAllChildrenWithTagCode(47);
        PlayBackElement element = (PlayBackElement)monitor.get(0);
        if (element.getDescription() != null) {
            return element.getDescription();
        }
        return String.valueOf(this.getMainElement().getId()) + " Playback";
    }

    protected String getSimTestName(String defaultName) {
        String className = DeviceKitUtilities.removeLastOccurence(defaultName, "Test");
        className = String.valueOf(className) + "Playback";
        return className;
    }

    protected String getStartContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("if (getDevice() != null) {\n");
        buffer.append("\tgetDevice().start();\n");
        buffer.append("}\n");
        buffer.append("super.start();\n");
        buffer.append("if (playbackLevel == CONNECTION_LEVEL && playbackConnection != null) {\n");
        buffer.append("\tplaybackConnection.startPlayback();\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    protected String getStopContents() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("super.stop();\n");
        buffer.append("if (getDevice() != null) {\n");
        buffer.append("\tgetDevice().exit();\n");
        buffer.append("}\n");
        return buffer.toString();
    }
}

