/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.util;

public class HtmlHelper {
    public String endTable(int indentation) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getIndentation(indentation));
        buffer.append("</table>\n");
        return buffer.toString();
    }

    public String endTableRow(int indentation) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getIndentation(indentation));
        buffer.append("</tr>\n");
        return buffer.toString();
    }

    public String getDefinitionList(String[] keys, String[] values) {
        if (keys == null || values == null || keys.length != values.length) {
            return new String();
        }
        StringBuffer buffer = new StringBuffer(keys.length * 32);
        buffer.append("<dl>\n");
        int i = 0;
        while (i < keys.length) {
            buffer.append("\t<dt>");
            buffer.append(keys[i]);
            buffer.append("</dt>\n");
            buffer.append("\t<dd>");
            buffer.append(values[i]);
            buffer.append("</dd>\n");
            ++i;
        }
        buffer.append("</dl>\n");
        return buffer.toString();
    }

    public String getExample(int indentation, String code) {
        return this.getExample(indentation, new String[]{code});
    }

    public String getExample(int indenation, String[] code) {
        int tindenation = indenation;
        StringBuffer buffer = new StringBuffer(code.length * 16);
        buffer.append(this.getIndentation(tindenation));
        buffer.append("<xmp>\n");
        ++tindenation;
        int i = 0;
        while (i < code.length) {
            buffer.append(this.getIndentation(tindenation));
            buffer.append(code[i]);
            buffer.append('\n');
            ++i;
        }
        buffer.append(this.getIndentation(--tindenation));
        buffer.append("</xmp>\n");
        return buffer.toString();
    }

    public String getIndentation(int indentation) {
        StringBuffer buffer = new StringBuffer(indentation);
        int i = 0;
        while (i < indentation) {
            buffer.append('\t');
            ++i;
        }
        return buffer.toString();
    }

    public String getLink(int indentation, String target, String text, boolean anchor) {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("<a href=\"");
        if (anchor) {
            buffer.append("#");
        }
        buffer.append(target);
        buffer.append("\">");
        buffer.append(text);
        buffer.append("</a>");
        return buffer.toString();
    }

    public String getTableCaption(int indentation, String name) {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append(this.getIndentation(indentation));
        buffer.append("<caption>");
        buffer.append(name);
        buffer.append("</caption>\n");
        return buffer.toString();
    }

    public String getTableColum(int indentation, String name) {
        return this.getTableColum(indentation, name, -1);
    }

    public String getTableColum(int indentation, String name, int percent) {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append(this.getIndentation(indentation));
        buffer.append("<th");
        if (percent > 0) {
            buffer.append(" width=" + percent + "%");
        }
        buffer.append(">");
        buffer.append(name);
        buffer.append("</th>\n");
        return buffer.toString();
    }

    public String getTableColumns(int indentation, String[] columnNames) {
        return this.getTableColumns(indentation, columnNames, null);
    }

    public String getTableColumns(int indentation, String[] columnNames, int[] percentages) {
        int tindentation = indentation;
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.startTableRow(tindentation, "align=\"left\""));
        if (columnNames == null || percentages != null && percentages.length != columnNames.length) {
            buffer.append(this.endTableRow(tindentation));
            return buffer.toString();
        }
        ++tindentation;
        int i = 0;
        while (i < columnNames.length) {
            if (percentages != null) {
                buffer.append(this.getTableColum(tindentation, columnNames[i], percentages[i]));
            } else {
                buffer.append(this.getTableColum(tindentation, columnNames[i]));
            }
            ++i;
        }
        buffer.append(this.endTableRow(--tindentation));
        return buffer.toString();
    }

    public String getTableData(int indentation, String data) {
        return this.getTableData(indentation, data, -1);
    }

    public String getTableData(int indentation, String data, int percent) {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append(this.getIndentation(indentation));
        buffer.append("<td");
        if (percent > 0) {
            buffer.append(" width=" + percent + "%");
        }
        buffer.append(">");
        buffer.append(data);
        buffer.append("</td>\n");
        return buffer.toString();
    }

    public String getTableRow(int indentation, String[] dataEntries) {
        return this.getTableRow(indentation, dataEntries, null);
    }

    public String getTableRow(int indentation, String[] dataEntries, int[] percentages) {
        int tindentation = indentation;
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.startTableRow(tindentation));
        if (dataEntries == null || percentages != null && percentages.length != dataEntries.length) {
            buffer.append(this.endTableRow(tindentation));
            return buffer.toString();
        }
        ++tindentation;
        int i = 0;
        while (i < dataEntries.length) {
            if (percentages == null) {
                buffer.append(this.getTableData(tindentation, dataEntries[i]));
            } else {
                buffer.append(this.getTableData(tindentation, dataEntries[i], percentages[i]));
            }
            ++i;
        }
        buffer.append(this.endTableRow(--tindentation));
        return buffer.toString();
    }

    public String getTableRow(int indentation, String data) {
        return this.getTableRow(indentation, new String[]{data});
    }

    public String startTable(int indentation) {
        return this.startTable(indentation, -1);
    }

    public String startTable(int indentation, int percent) {
        return this.startTable(indentation, percent, null);
    }

    public String startTable(int indentation, int percent, String attributes) {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append(this.getIndentation(indentation));
        buffer.append("<table");
        if (percent > 0) {
            buffer.append(" width=");
            buffer.append(percent);
            buffer.append('%');
        }
        if (attributes != null) {
            buffer.append(' ');
            buffer.append(attributes);
        }
        buffer.append(">\n");
        return buffer.toString();
    }

    public String startTableRow(int indentation) {
        return this.startTableRow(indentation, null);
    }

    public String startTableRow(int indentation, String attributes) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getIndentation(indentation));
        buffer.append("<tr");
        if (attributes != null) {
            buffer.append(' ');
            buffer.append(attributes);
        }
        buffer.append(">\n");
        return buffer.toString();
    }
}

