/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.testmanager.view;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.soda.devicekit.ui.testmanager.TestManagerMessages;
import org.eclipse.soda.devicekit.ui.testmanager.TestManagerPlugin;
import org.eclipse.soda.devicekit.ui.testmanager.model.TestModel;
import org.eclipse.soda.devicekit.ui.testmanager.view.TestRunnerViewPart;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;

public class CopyFailureListAction
extends Action {
    private final Clipboard fClipboard;
    private final TestRunnerViewPart fRunner;

    public CopyFailureListAction(TestRunnerViewPart runner, Clipboard clipboard) {
        super(TestManagerMessages.CopyFailureList_action_label);
        this.fRunner = runner;
        this.fClipboard = clipboard;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.soda.devicekit.ui.testmanager.copy_failure_list_action_context");
    }

    private String convertLineTerminators(String in) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StringReader stringReader = new StringReader(in);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                printWriter.println(line);
            }
        }
        catch (IOException iOException) {
            return in;
        }
        return stringWriter.toString();
    }

    public String getAllFailureTraces() {
        StringBuffer buf = new StringBuffer();
        Element[] failures = this.fRunner.getAllFailures();
        String lineDelim = System.getProperty("line.separator", "\n");
        int i = 0;
        while (i < failures.length) {
            Element failure = failures[i];
            String name = this.fRunner.getElementDescription(failure);
            buf.append(name).append(lineDelim);
            String failureTrace = TestModel.getTextContent(failure);
            if (failureTrace != null) {
                buf.append(this.convertLineTerminators(failureTrace));
                buf.append(lineDelim);
            }
            ++i;
        }
        return buf.toString();
    }

    public void run() {
        block3: {
            TextTransfer plainTextTransfer = TextTransfer.getInstance();
            try {
                this.fClipboard.setContents((Object[])new String[]{this.getAllFailureTraces()}, new Transfer[]{plainTextTransfer});
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)TestManagerPlugin.getActiveWorkbenchShell(), (String)TestManagerMessages.CopyFailureList_problem, (String)TestManagerMessages.CopyFailureList_clipboard_busy)) break block3;
                this.run();
            }
        }
    }
}

