/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.testmanager.view;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.soda.devicekit.ui.testmanager.TestManagerMessages;
import org.eclipse.soda.devicekit.ui.testmanager.util.ExceptionHandler;
import org.eclipse.soda.devicekit.ui.testmanager.view.TestRunnerViewPart;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class OpenEditorAction
extends Action {
    protected String fClassName;
    protected TestRunnerViewPart fTestRunner;
    private final boolean fActivate;

    protected OpenEditorAction(TestRunnerViewPart testRunner, String testClassName) {
        this(testRunner, testClassName, true);
    }

    protected OpenEditorAction(TestRunnerViewPart testRunner, String className, boolean activate) {
        super(TestManagerMessages.OpenEditorAction_action_label);
        this.fClassName = className;
        this.fTestRunner = testRunner;
        this.fActivate = activate;
    }

    protected abstract IJavaElement findElement(IJavaProject var1, String var2) throws CoreException;

    protected final IType findType(final IJavaProject project, String className) throws JavaModelException {
        final IType[] result = new IType[1];
        final String dottedName = className.replace('$', '.');
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IJavaSearchScope scope = project == null ? SearchEngine.createWorkspaceScope() : SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{project});
                        int lastDot = dottedName.lastIndexOf(46);
                        TypeNameMatchRequestor nameMatchRequestor = new TypeNameMatchRequestor(this, result){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ IType[] val$result;
                            {
                                this.this$1 = var1_1;
                                this.val$result = iTypeArray;
                            }

                            public void acceptTypeNameMatch(TypeNameMatch match) {
                                this.val$result[0] = match.getType();
                            }
                        };
                        new SearchEngine().searchAllTypeNames(lastDot >= 0 ? dottedName.substring(0, lastDot).toCharArray() : null, 8, (lastDot >= 0 ? dottedName.substring(lastDot + 1) : dottedName).toCharArray(), 8, 0, scope, nameMatchRequestor, 3, monitor);
                    }
                    catch (JavaModelException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), TestManagerMessages.OpenEditorAction_error_cannotopen_title, TestManagerMessages.OpenEditorAction_error_cannotopen_message);
        }
        catch (InterruptedException interruptedException) {}
        return result[0];
    }

    protected String getClassName() {
        return this.fClassName;
    }

    protected IJavaProject getLaunchedProject() {
        return this.fTestRunner.getLaunchedProject();
    }

    protected Shell getShell() {
        return this.fTestRunner.getSite().getShell();
    }

    protected abstract void reveal(ITextEditor var1);

    public void run() {
        ITextEditor textEditor = null;
        try {
            IJavaElement element = this.findElement(this.getLaunchedProject(), this.fClassName);
            if (element == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)TestManagerMessages.OpenEditorAction_error_cannotopen_title, (String)TestManagerMessages.OpenEditorAction_error_cannotopen_message);
                return;
            }
            textEditor = (ITextEditor)JavaUI.openInEditor((IJavaElement)element, (boolean)this.fActivate, (boolean)false);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)TestManagerMessages.OpenEditorAction_error_dialog_title, (String)TestManagerMessages.OpenEditorAction_error_dialog_message, (IStatus)e.getStatus());
            return;
        }
        if (textEditor == null) {
            this.fTestRunner.registerInfoMessage(TestManagerMessages.OpenEditorAction_message_cannotopen);
            return;
        }
        this.reveal(textEditor);
    }
}

