/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.action.wizard;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.soda.devicekit.ui.action.wizard.DeviceWorkingSetMessages;
import org.eclipse.soda.devicekit.ui.wizard.DeviceKitPage;
import org.eclipse.soda.devicekit.ui.wizard.IWizardMessages;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;

public class DeviceWorkingSetPage
extends DeviceKitPage {
    public static final String[] BUTTONS = new String[]{"feature-generate", "feature-source-generate", "feature-sdk-generate", "plugin-generate", "plugin-samples-generate", "plugin-doc-reference-generate", "workingset-generate"};
    public static final String[] TEXT = new String[0];
    private static IWizardMessages messages = DeviceWorkingSetMessages.getInstance();
    protected List list = null;
    protected Map listExtensions = new HashMap();

    public DeviceWorkingSetPage(String pageName) {
        super(pageName);
        this.setTitle(messages.getString("fixSource"));
    }

    public DeviceWorkingSetPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected Button createCheckBoxControl(Composite composite, String key, Map map) {
        Button button = super.createCheckBoxControl(composite, key);
        if (map.get(key) != null) {
            button.setSelection(true);
        }
        return button;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setMessage(this.getDefaultMessage());
        Composite composite = new Composite(parent, 0);
        Dialog.applyDialogFont((Control)composite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.createCustomControl(composite);
        Dialog.applyDialogFont((Control)composite);
        composite.layout(true);
        this.setControl((Control)composite);
        parent.layout(true);
        parent.redraw();
        this.updatePageCompletion();
    }

    protected void createCustomControl(Composite composite) {
        Object object;
        this.setListExtensions(this.createListExtensions());
        int size = this.list.size();
        if (size == 1 && (object = this.list.get(0)) instanceof IWorkingSet) {
            IWorkingSet workingSet = (IWorkingSet)object;
            String name = workingSet.getName();
            this.getListExtensions().put("name", name);
            this.createTextControl(composite, "name", this.getListExtensions());
        }
        int i = 0;
        while (i < TEXT.length) {
            this.createTextControl(composite, TEXT[i], this.getListExtensions());
            ++i;
        }
        i = 0;
        while (i < BUTTONS.length) {
            this.createCheckBoxControl(composite, BUTTONS[i], this.getListExtensions());
            ++i;
        }
    }

    public Map createListExtensions() {
        HashMap<String, String> map = new HashMap<String, String>();
        List list = this.getList();
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                Object element = list.get(i);
                String extension = null;
                if (element instanceof ICompilationUnit || element instanceof IType) {
                    extension = "java";
                } else if (element instanceof IFile) {
                    IFile file = (IFile)element;
                    extension = file.getFileExtension();
                } else {
                    int j = 0;
                    while (j < BUTTONS.length) {
                        map.put(BUTTONS[j], "true");
                        ++j;
                    }
                }
                if (extension != null && extension.length() > 0) {
                    map.put(extension.toLowerCase(), "true");
                }
                ++i;
            }
        }
        return map;
    }

    protected Text createTextControl(Composite composite, String key, Map map) {
        Text text = super.createTextControl(composite, key);
        Object value = map.get(key);
        if (value != null) {
            text.setText(value.toString());
        }
        return text;
    }

    protected String getKey() {
        return "profile";
    }

    public List getList() {
        return this.list;
    }

    public Map getListExtensions() {
        return this.listExtensions;
    }

    public String getString(String key) {
        try {
            return messages.getString(key);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return key;
        }
    }

    public void setList(List list) {
        this.list = list;
    }

    public void setListExtensions(Map listExtensions) {
        this.listExtensions = listExtensions;
    }

    protected boolean updatePageErrors() {
        this.update(true, this.doesNextPageExist(), null, null);
        return true;
    }
}

