/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.transport.wizard;

import org.eclipse.soda.devicekit.ui.transport.wizard.ConnectionModelPage;
import org.eclipse.soda.devicekit.ui.transport.wizard.Validator;

public class DoubleValidator
extends Validator {
    public DoubleValidator(ConnectionModelPage connectionModelPage) {
        super(connectionModelPage);
        this.setMaximum(new Double(Double.MAX_VALUE));
        this.setMinimum(new Double(Double.MIN_VALUE));
    }

    public boolean isValid(String value) {
        double doubleValue;
        block4: {
            try {
                doubleValue = this.parse(value);
                if (!(doubleValue < this.getMinimum().doubleValue())) break block4;
                this.updateError("validator.min", value);
                return false;
            }
            catch (Exception exception) {
                this.updateError("validator.number", value);
                return false;
            }
        }
        if (doubleValue > this.getMaximum().doubleValue()) {
            this.updateError("validator.max", value);
            return false;
        }
        return true;
    }

    public double parse(String value) throws NumberFormatException {
        return Double.parseDouble(value);
    }
}

