/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.connection.factory;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.soda.dk.connection.Connection;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.core.factory.CoreFactory;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceFactoryAdvisor;
import org.osgi.service.cm.ManagedServiceFactory;

public abstract class ConnectionFactory
extends CoreFactory
implements ManagedServiceFactory,
IManagedServiceFactoryAdvisor {
    public synchronized Object create(String pid, Dictionary properties, IBundleActivationManager manager) {
        this.validateConfigurationIds(pid, properties);
        ConnectionService connection = this.createService(properties);
        if (connection != null) {
            Hashtable serviceProperties = this.createProperties();
            this.updateProperties(serviceProperties, properties);
            manager.addExportedServices(this.getExportedServiceNames(pid, null, properties, manager), (Object)connection, (Dictionary)serviceProperties);
        }
        return connection;
    }

    public abstract ConnectionService createService(Dictionary var1);

    public synchronized void destroy(String pid, Object object, Dictionary properties, IBundleActivationManager manager) {
        try {
            Connection connection = (Connection)object;
            connection.exit();
        }
        catch (Exception e) {
            EscObject.handleStaticException((Throwable)e);
        }
        super.destroy(pid, object, properties, manager);
    }

    public String getServiceName() {
        return "org.eclipse.soda.dk.connection.service.ConnectionService";
    }

    public synchronized Object update(String pid, Object object, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        ConnectionService connection = (ConnectionService)object;
        int compareLevel = this.compare(oldProperties, properties, this.getMinorProperties());
        switch (compareLevel) {
            case 0: {
                return object;
            }
            case 1: {
                connection.setConfigurationInformation(properties);
                return object;
            }
            case 2: {
                manager.removeExportedService(this.getServiceName(), object);
                Thread.yield();
                try {
                    connection.exit();
                }
                catch (Exception e) {
                    EscObject.handleStaticException((Throwable)e);
                }
                return this.create(pid, properties, manager);
            }
        }
        return connection;
    }
}

