/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transform.testcase;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.transform.MinimumTransform;

public class MinimumTransformTestcase
extends TestCase {
    private MinimumTransform transform;
    private Object obj;
    static /* synthetic */ Class class$0;

    public MinimumTransformTestcase(String name) {
        super(name);
    }

    public static void main(String[] arguments) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.transform.testcase.MinimumTransformTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testDecodeForException() {
        this.transform = new MinimumTransform(0);
        this.obj = new Object();
        RuntimeException ee = null;
        try {
            this.transform.decode(this.obj);
        }
        catch (RuntimeException e) {
            ee = e;
        }
        MinimumTransformTestcase.assertTrue((String)"Should Have Thrown Exception", (ee != null ? 1 : 0) != 0);
        MinimumTransformTestcase.assertTrue((String)("Unknown Exception Thrown " + ee), (boolean)(ee instanceof ClassCastException));
    }

    public void testDecodeForGreaterInitialValue() {
        this.transform = new MinimumTransform(10);
        this.obj = this.transform.decode((Object)new Integer(5));
        MinimumTransformTestcase.assertEquals((int)5, (int)((Integer)this.obj));
    }

    public void testDecodeForLesserInitialValue() {
        this.transform = new MinimumTransform(5);
        this.obj = this.transform.decode((Object)new Integer(10));
        MinimumTransformTestcase.assertEquals((int)5, (int)((Integer)this.obj));
    }

    public void testDecodeForTrickyGreaterInitialValue1() {
        this.transform = new MinimumTransform(10);
        this.obj = this.transform.decode((Object)new Double(10.11111111));
        MinimumTransformTestcase.assertEquals((int)10, (int)((Integer)this.obj));
    }

    public void testDecodeForTrickyGreaterInitialValue2() {
        this.transform = new MinimumTransform(9);
        this.obj = this.transform.decode((Object)new Double(8.99999999));
        MinimumTransformTestcase.assertEquals((double)8.99999999, (double)((Double)this.obj), (double)0.0);
    }

    public void testEncodeForException() {
        this.transform = new MinimumTransform(0);
        this.obj = new Object();
        RuntimeException ee = null;
        try {
            this.transform.encode(this.obj);
        }
        catch (RuntimeException e) {
            ee = e;
        }
        MinimumTransformTestcase.assertTrue((String)"Should Have Thrown Exception", (ee != null ? 1 : 0) != 0);
        MinimumTransformTestcase.assertTrue((String)("Unknown Exception Thrown " + ee), (boolean)(ee instanceof ClassCastException));
    }

    public void testEncodeForGreaterInitialValue() {
        this.transform = new MinimumTransform(10);
        this.obj = this.transform.encode((Object)new Integer(5));
        MinimumTransformTestcase.assertTrue((String)"MinimumTransform 10 > 5", (5 == (Integer)this.obj ? 1 : 0) != 0);
    }

    public void testEncodeForLesserInitialValue() {
        this.transform = new MinimumTransform(5);
        this.obj = this.transform.encode((Object)new Integer(10));
        MinimumTransformTestcase.assertTrue((String)"MinimumTransform 10 > 5", (5 == (Integer)this.obj ? 1 : 0) != 0);
    }

    public void testEncodeForTrickyGreaterInitialValue1() {
        this.transform = new MinimumTransform(10);
        this.obj = this.transform.encode((Object)new Double(10.11111111));
        MinimumTransformTestcase.assertTrue((String)"MinimumTransform 10.11111111 > 10 ", (10 == (Integer)this.obj ? 1 : 0) != 0);
    }

    public void testEncodeForTrickyGreaterInitialValue2() {
        this.transform = new MinimumTransform(9);
        this.obj = this.transform.encode((Object)new Double(8.99999999));
        MinimumTransformTestcase.assertTrue((String)"MinimumTransform 9 > 8.999999999", (8.99999999 == (Double)this.obj ? 1 : 0) != 0);
    }

    public void testTransformIntConstructor() {
        this.transform = new MinimumTransform(0);
        MinimumTransformTestcase.assertTrue((String)"MinimumTransform Constructor should not return a Null Object", (this.transform != null ? 1 : 0) != 0);
    }
}

