/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.message;

import org.eclipse.soda.dk.filter.service.FilterService;
import org.eclipse.soda.dk.message.ParameterMessage;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.message.service.ResponseMessageService;
import org.eclipse.soda.dk.parameter.service.ParameterService;

public class ResponseMessage
extends ParameterMessage
implements ResponseMessageService {
    private MessageService sentMessage;

    public ResponseMessage(byte[] data, ParameterService parameter, MessageService sentMessage) {
        this(data, null, parameter, sentMessage);
    }

    public ResponseMessage(byte[] data, FilterService filter, ParameterService parameter, MessageService sentMessage) {
        super(data, filter, parameter);
        this.setSentMessage(sentMessage);
    }

    public MessageService getSentMessage() {
        return this.sentMessage;
    }

    public MessageService matches(MessageService message) {
        if (message instanceof ResponseMessageService) {
            ResponseMessageService responseMessage = (ResponseMessageService)message;
            if (this.getSentMessage().matches(responseMessage.getSentMessage()) != null) {
                return super.matches(message);
            }
        }
        return null;
    }

    public void setSentMessage(MessageService sentMessage) {
        if (sentMessage == null) {
            throw new IllegalArgumentException();
        }
        this.sentMessage = sentMessage;
    }
}

