/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.parameter.service.CountBlockService;
import org.eclipse.soda.dk.parameter.service.LengthBlockService;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;

public class ParameterCursor
extends EscObject
implements ParameterCursorService {
    private int offset = 0;
    private int offsetDelta = 0;
    private int length = 0;
    private int count = -1;
    protected Object value;
    protected boolean insert = false;
    private int messageLength = 0;
    private LengthBlockService lengthBlock;
    private ParameterCursorService lengthCursor;
    private CountBlockService countBlock;
    private ParameterCursorService countCursor;
    private ParameterCursorService parent;

    public ParameterCursor() {
    }

    public ParameterCursor(int messageLength) {
        this.setMessageLength(messageLength);
    }

    public ParameterCursor(ParameterCursorService value) {
        this.count = value.getCount();
        this.length = value.getLength();
        this.offset = value.getOffset();
        this.offsetDelta = value.getOffsetDelta();
        this.countBlock = value.getCountBlock();
        this.countCursor = value.getCountCursor();
        this.lengthBlock = value.getLengthBlock();
        this.lengthCursor = value.getLengthCursor();
        this.parent = value.getParent();
        this.insert = value.isInsert();
        this.messageLength = value.getMessageLength();
    }

    public int getCount() {
        return this.count;
    }

    public CountBlockService getCountBlock() {
        return this.countBlock;
    }

    public ParameterCursorService getCountCursor() {
        return this.countCursor;
    }

    public int getLength() {
        return this.length;
    }

    public LengthBlockService getLengthBlock() {
        return this.lengthBlock;
    }

    public ParameterCursorService getLengthCursor() {
        return this.lengthCursor;
    }

    public int getMessageLength() {
        return this.messageLength;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getOffsetAbsolute() {
        return this.getOffset() + this.getOffsetDelta();
    }

    public int getOffsetDelta() {
        return this.offsetDelta;
    }

    public ParameterCursorService getParent() {
        return this.parent;
    }

    public int getRemainingLength() {
        int length = this.getLength();
        if (length == Integer.MAX_VALUE || length == Integer.MIN_VALUE) {
            return this.getMessageLength();
        }
        int offset = this.getOffset();
        if (offset == Integer.MAX_VALUE || offset == Integer.MIN_VALUE) {
            return this.getMessageLength();
        }
        return this.getMessageLength() - this.getOffsetAbsolute();
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isInsert() {
        return this.insert;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setCountBlock(CountBlockService countBlock) {
        this.countBlock = countBlock;
        if (countBlock != null) {
            this.setCountCursor(new ParameterCursor(this));
        } else {
            this.setCountCursor(null);
        }
    }

    public void setCountCursor(ParameterCursorService countCursor) {
        this.countCursor = countCursor;
    }

    public void setInsert(boolean insert) {
        this.insert = insert;
    }

    public void setLength(int length) {
        if (length < 0) {
            throw new IllegalArgumentException(String.valueOf(length));
        }
        this.length = length;
    }

    public void setLengthBlock(LengthBlockService lengthBlock) {
        this.lengthBlock = lengthBlock;
        if (lengthBlock != null) {
            this.setLengthCursor(new ParameterCursor(this));
        } else {
            this.setLengthCursor(null);
        }
    }

    public void setLengthCursor(ParameterCursorService lengthCursor) {
        this.lengthCursor = lengthCursor;
    }

    public void setMessageLength(int messageLength) {
        if (messageLength < 0) {
            throw new IllegalArgumentException(String.valueOf(messageLength));
        }
        this.messageLength = messageLength;
        if (this.parent != null) {
            this.parent.setMessageLength(messageLength);
        }
    }

    public void setOffset(int offset) {
        if (offset < 0 && offset > Integer.MIN_VALUE) {
            throw new IllegalArgumentException(String.valueOf(offset));
        }
        this.offset = offset;
    }

    public void setOffsetAbsolute(int offsetAbsolute) {
        int offset = offsetAbsolute - this.getOffsetDelta();
        if (offset < 0) {
            throw new IllegalArgumentException(String.valueOf(offset));
        }
        this.setOffset(offset);
    }

    public void setOffsetDelta(int offsetDelta) {
        this.offsetDelta = offsetDelta;
    }

    public void setParent(ParameterCursorService parent) {
        this.parent = parent;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String toString() {
        ParameterCursorService parent;
        ParameterCursorService lengthCursor;
        LengthBlockService lengthBlock;
        ParameterCursorService countCursor;
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append(super.toString());
        buffer.append("={count=");
        buffer.append(this.getCount());
        buffer.append(",length=");
        buffer.append(this.getLength());
        buffer.append(",offset=");
        buffer.append(this.getOffset());
        buffer.append(",offsetDelta=");
        buffer.append(this.getOffsetDelta());
        CountBlockService countBlock = this.getCountBlock();
        if (countBlock != null) {
            buffer.append(",countBlock=");
            buffer.append(countBlock);
        }
        if ((countCursor = this.getCountCursor()) != null) {
            buffer.append(",countCursor=");
            buffer.append(countCursor);
        }
        if ((lengthBlock = this.getLengthBlock()) != null) {
            buffer.append(",lengthBlock=");
            buffer.append(lengthBlock);
        }
        if ((lengthCursor = this.getLengthCursor()) != null) {
            buffer.append(",lengthCursor=");
            buffer.append(lengthCursor);
        }
        if ((parent = this.getParent()) != null) {
            buffer.append(",parent=");
            buffer.append(parent);
        }
        buffer.append(",isInsert=");
        buffer.append(this.isInsert());
        buffer.append(",messageLenth=");
        buffer.append(this.getMessageLength());
        buffer.append('}');
        return buffer.toString();
    }

    public void updateMessageLength(int length) {
        if (length < 0) {
            throw new IllegalArgumentException(String.valueOf(length));
        }
        this.messageLength += length;
        if (this.parent != null) {
            this.parent.updateMessageLength(length);
        }
    }
}

