/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.script;

import java.util.List;
import java.util.Map;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.script.ScriptAssignment;
import org.eclipse.soda.dk.script.ScriptGroup;
import org.eclipse.soda.dk.script.ScriptOperator;
import org.eclipse.soda.dk.script.ScriptStatement;

public class ScriptObject
extends EscObject {
    public Object evaluate(Map variables, Map locals) {
        return null;
    }

    public Object evaluate(Map variables, Map locals, List tokens, int start, int end) {
        Object item;
        int count = end - start;
        Object startObject = tokens.get(start);
        if (startObject instanceof ScriptStatement) {
            return this.evaluate(variables, locals, tokens, start + 1, end);
        }
        Object endObject = tokens.get(end);
        if (endObject instanceof ScriptStatement) {
            return this.evaluate(variables, locals, tokens, start, end - 1);
        }
        int level = 0;
        ScriptGroup scriptGroup = null;
        int i = start;
        while (i <= end) {
            item = tokens.get(i);
            if (item instanceof ScriptStatement) {
                if (level == 0) {
                    this.evaluate(variables, locals, tokens, start, i - 1);
                    return this.evaluate(variables, locals, tokens, i + 1, end);
                }
            } else {
                if (item instanceof ScriptGroup && scriptGroup == null) {
                    scriptGroup = (ScriptGroup)item;
                }
                if (scriptGroup != null) {
                    if (scriptGroup.matching(item)) {
                        ++level;
                    } else if (scriptGroup.matchingEnd(item)) {
                        --level;
                    }
                }
            }
            ++i;
        }
        if (startObject instanceof ScriptGroup) {
            level = 1;
            scriptGroup = (ScriptGroup)startObject;
            i = start + 1;
            while (i <= end) {
                item = tokens.get(i);
                if (scriptGroup.matching(item)) {
                    ++level;
                } else if (scriptGroup.matchingEnd(item) && --level == 0) {
                    if (i == end) {
                        return this.evaluate(variables, locals, tokens, start + 1, i - 1);
                    }
                    Object firstObject = this.evaluate(variables, locals, tokens, start + 1, i - 1);
                    Object oneObject = tokens.get(i + 1);
                    Object twoObject = this.evaluate(variables, locals, tokens, i + 2, end);
                    if (oneObject instanceof ScriptOperator) {
                        ScriptOperator scriptOperator = (ScriptOperator)oneObject;
                        return scriptOperator.evaluate(variables, locals, firstObject, twoObject);
                    }
                }
                ++i;
            }
        } else {
            switch (count) {
                case 0: {
                    return this.getConstant(variables, locals, startObject);
                }
                case 1: {
                    Object plusOneObject = tokens.get(start + 1);
                    boolean cfr_ignored_0 = plusOneObject instanceof ScriptOperator;
                    break;
                }
                case 2: {
                    ScriptAssignment scriptAssignment;
                    ScriptOperator scriptOperator;
                    Object oneObject = tokens.get(start + 1);
                    Object twoObject = tokens.get(start + 2);
                    if (oneObject instanceof ScriptOperator) {
                        scriptOperator = (ScriptOperator)oneObject;
                        return scriptOperator.evaluate(variables, locals, startObject, twoObject);
                    }
                    if (oneObject instanceof ScriptAssignment) {
                        scriptAssignment = (ScriptAssignment)oneObject;
                        return scriptAssignment.evaluate(variables, locals, startObject, twoObject);
                    }
                    break;
                }
                default: {
                    ScriptOperator scriptOperator;
                    Object oneObject = tokens.get(start + 1);
                    Object twoObject = this.evaluate(variables, locals, tokens, start + 2, end);
                    if (oneObject instanceof ScriptOperator) {
                        scriptOperator = (ScriptOperator)oneObject;
                        return scriptOperator.evaluate(variables, locals, startObject, twoObject);
                    }
                    if (!(oneObject instanceof ScriptAssignment)) break;
                    ScriptAssignment scriptAssignment = (ScriptAssignment)oneObject;
                    return scriptAssignment.evaluate(variables, locals, startObject, twoObject);
                }
            }
        }
        return null;
    }

    public Boolean getBoolean(char character, Object first, Object second) {
        if (first instanceof Number) {
            if (second instanceof Number) {
                if (first instanceof Double || first instanceof Float || second instanceof Double || second instanceof Float) {
                    double double0 = ((Number)first).doubleValue();
                    double double1 = ((Number)second).doubleValue();
                    switch (character) {
                        case '>': {
                            return double0 > double1 ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case '<': {
                            return double0 < double1 ? Boolean.TRUE : Boolean.FALSE;
                        }
                    }
                } else {
                    long long0 = ((Number)first).longValue();
                    long long1 = ((Number)second).longValue();
                    switch (character) {
                        case '>': {
                            return long0 > long1 ? Boolean.TRUE : Boolean.FALSE;
                        }
                        case '<': {
                            return long0 < long1 ? Boolean.TRUE : Boolean.FALSE;
                        }
                    }
                }
                throw new RuntimeException(String.valueOf(character));
            }
            throw new RuntimeException(String.valueOf(second));
        }
        throw new RuntimeException(String.valueOf(first));
    }

    public Boolean getBoolean(char[] characters, Object first, Object second) {
        int length = characters.length;
        if (length == 1) {
            char character = characters[0];
            return this.getBoolean(character, first, second);
        }
        String operator = new String(characters);
        if (first instanceof Number && second instanceof Number) {
            boolean doubleValues = true;
            double double0 = 0.0;
            double double1 = 0.0;
            long long0 = 0L;
            long long1 = 0L;
            if (first instanceof Double || first instanceof Float || second instanceof Double || second instanceof Float) {
                double0 = ((Number)first).doubleValue();
                double1 = ((Number)second).doubleValue();
                doubleValues = true;
            } else {
                long0 = ((Number)first).longValue();
                long1 = ((Number)second).longValue();
                doubleValues = false;
            }
            if (operator.equals("==")) {
                return (doubleValues ? double0 == double1 : long0 == long1) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (operator.equals("!=")) {
                return (doubleValues ? double0 != double1 : long0 != long1) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (operator.equals("<=")) {
                return (doubleValues ? double0 <= double1 : long0 <= long1) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (operator.equals(">=")) {
                return (doubleValues ? double0 >= double1 : long0 >= long1) ? Boolean.TRUE : Boolean.FALSE;
            }
            throw new RuntimeException(String.valueOf(second));
        }
        if (first instanceof Boolean) {
            if (second instanceof Boolean) {
                boolean boolean0 = (Boolean)first;
                boolean boolean1 = (Boolean)second;
                if (operator.equals("&&")) {
                    return boolean0 && boolean1 ? Boolean.TRUE : Boolean.FALSE;
                }
                if (operator.equals("||")) {
                    return boolean0 || boolean1 ? Boolean.TRUE : Boolean.FALSE;
                }
                throw new RuntimeException(String.valueOf(second));
            }
            throw new RuntimeException(String.valueOf(first));
        }
        throw new RuntimeException(String.valueOf(second));
    }

    public Object getConstant(Map variables, Map locals, Object object) {
        if (object instanceof ScriptObject) {
            return ((ScriptObject)object).evaluate(variables, locals);
        }
        return object;
    }

    public Number getNumber(char character, Object first, Object second) {
        if (first instanceof Number) {
            if (second instanceof Number) {
                if (first instanceof Double || first instanceof Float || second instanceof Double || second instanceof Float) {
                    double double0 = ((Number)first).doubleValue();
                    double double1 = ((Number)second).doubleValue();
                    switch (character) {
                        case '+': {
                            return new Double(double0 + double1);
                        }
                        case '-': {
                            return new Double(double0 - double1);
                        }
                        case '/': {
                            return new Double(double0 / double1);
                        }
                        case '*': {
                            return new Double(double0 * double1);
                        }
                        case '&': {
                            long long0 = ((Number)first).longValue();
                            long long1 = ((Number)second).longValue();
                            return ScriptObject.createNumber(long0 & long1);
                        }
                        case '|': {
                            long long0 = ((Number)first).longValue();
                            long long1 = ((Number)second).longValue();
                            return ScriptObject.createNumber(long0 | long1);
                        }
                        case '%': {
                            long long0 = ((Number)first).longValue();
                            long long1 = ((Number)second).longValue();
                            return ScriptObject.createNumber(long0 % long1);
                        }
                    }
                } else {
                    long long0 = ((Number)first).longValue();
                    long long1 = ((Number)second).longValue();
                    switch (character) {
                        case '+': {
                            return ScriptObject.createNumber(long0 + long1);
                        }
                        case '-': {
                            return ScriptObject.createNumber(long0 - long1);
                        }
                        case '/': {
                            return ScriptObject.createNumber(long0 / long1);
                        }
                        case '%': {
                            return ScriptObject.createNumber(long0 % long1);
                        }
                        case '*': {
                            return ScriptObject.createNumber(long0 * long1);
                        }
                        case '&': {
                            return ScriptObject.createNumber(long0 & long1);
                        }
                        case '|': {
                            return ScriptObject.createNumber(long0 | long1);
                        }
                    }
                }
                throw new RuntimeException(String.valueOf(character));
            }
            throw new RuntimeException(String.valueOf(second));
        }
        throw new RuntimeException(String.valueOf(first));
    }

    public Number getNumber(char[] characters, Object first, Object second) {
        int length = characters.length;
        if (length == 1) {
            char character = characters[0];
            return this.getNumber(character, first, second);
        }
        String operator = new String(characters);
        if (operator.equals("<<") || operator.equals(">>")) {
            if (first instanceof Number) {
                if (second instanceof Number) {
                    long long0 = ((Number)first).longValue();
                    long long1 = ((Number)second).longValue();
                    if (operator.equals("<<")) {
                        return ScriptObject.createNumber(long0 << (int)long1);
                    }
                    if (operator.equals(">>")) {
                        return ScriptObject.createNumber(long0 >> (int)long1);
                    }
                    throw new RuntimeException(operator);
                }
                throw new RuntimeException(String.valueOf(second));
            }
            throw new RuntimeException(String.valueOf(first));
        }
        throw new RuntimeException(new String(characters));
    }
}

