/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.command;

import org.eclipse.soda.dk.command.SimpleMessageCommand;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.transport.service.ResponseListener;
import org.eclipse.soda.dk.transport.service.TransportService;

public class SimpleDataCommand
extends SimpleMessageCommand {
    public SimpleDataCommand(String key, MessageService message) {
        super(key, message);
    }

    public void execute(ChannelService channel, Object data) {
        if (data == null) {
            this.execute(channel);
        } else {
            try {
                MessageService newMessage = (MessageService)this.getMessage().clone();
                this.getDevice().send(channel, newMessage.encodeMessage(newMessage, data), (ResponseListener)this);
            }
            catch (Exception exception) {
                this.handleError(exception, 1);
            }
            try {
                CommandListener commandListener = this.getCommandListener();
                if (commandListener != null) {
                    this.fireCommandExecuted(commandListener, EscObject.getCurrentTimestamp(), channel, data);
                }
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
        }
    }

    public void messageReceived(TransportService transportService, Object timestamp, ChannelService channel, MessageService message) {
        CommandListener commandListener = this.getCommandListener();
        if (commandListener != null) {
            try {
                MessageService matchMessage = this.getMessage().matches(message);
                if (matchMessage != null) {
                    this.fireCommandExecuted(commandListener, timestamp, channel, matchMessage.decodeMessage(message));
                }
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
        }
    }

    public void messageReceived(TransportService transportService, Object timestamp, MessageService message) {
        this.messageReceived(transportService, timestamp, null, message);
    }
}

